/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.config;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.Properties;

class ConfigurationParser {
    private static final LoggerX LOG = LoggerFactoryX.getLogger(ConfigurationParser.class);
    private Properties m_properties = new Properties();

    ConfigurationParser() {
    }

    void parse(File file) throws ParseException {
        if (file == null) {
            LOG.warn("parsing NULL file, so fallback on default configuration!");
            return;
        }
        if (!file.exists()) {
            LOG.warn(String.format("parsing not existing file %s, so fallback on default configuration!", file.getAbsolutePath()));
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(file.toPath(), Charset.forName("UTF-8"));
            this.parse(reader);
        }
        catch (IOException fex) {
            LOG.warn("parsing not existing file {}, fallback on default configuration!", (Object)file.getAbsolutePath(), (Object)fex);
        }
    }

    void parse(Reader reader) throws ParseException {
        if (reader == null) {
            LOG.warn("parsing NULL reader, so fallback on default configuration!");
            return;
        }
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int commentMarker = line.indexOf(35);
                if (commentMarker != -1) {
                    if (commentMarker == 0) continue;
                    throw new ParseException(line, commentMarker);
                }
                if (line.isEmpty() || line.matches("^\\s*$")) continue;
                int delimiterIdx = line.indexOf(32);
                String key = line.substring(0, delimiterIdx).trim();
                String value = line.substring(delimiterIdx).trim();
                this.m_properties.put(key, value);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    Properties getProperties() {
        return this.m_properties;
    }
}

