/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.NamespaceUtil;
import com.github.netty.core.util.NettyThreadX;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public class ThreadFactoryX
extends DefaultThreadFactory
implements ThreadFactory {
    private final String preName;
    private boolean daemon = false;
    private ThreadGroup threadGroup;

    public ThreadFactoryX(String preName, Class<?> poolType) {
        this(preName, poolType, 10, false);
    }

    public ThreadFactoryX(String preName, Class<?> poolType, int priority, boolean daemon) {
        super(NamespaceUtil.newIdName(poolType), priority);
        this.preName = preName;
        this.daemon = daemon;
        this.threadGroup = System.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : System.getSecurityManager().getThreadGroup();
    }

    public ThreadFactoryX(String poolName, String preName) {
        super(poolName);
        this.preName = preName;
        this.threadGroup = System.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : System.getSecurityManager().getThreadGroup();
    }

    protected Thread newThread(Runnable r, String name) {
        NettyThreadX thread = new NettyThreadX(this.threadGroup, r, name);
        if (this.preName != null && this.preName.length() > 0) {
            ((Thread)((Object)thread)).setName("NettyX-" + this.preName + "-" + ((Thread)((Object)thread)).getName());
        }
        if (this.daemon) {
            ((Thread)((Object)thread)).setDaemon(true);
        }
        return thread;
    }
}

