/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.ByteBufAllocatorX;
import com.github.netty.core.util.IOUtil;
import com.github.netty.core.util.Recycler;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;

class ReadOnlyPooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private byte[] array = EmptyArrays.EMPTY_BYTES;
    private ByteBuffer tmpNioBuf;
    private int offset = 0;
    private int capacity;
    private static final Recycler<ReadOnlyPooledHeapByteBuf> RECYCLER = new Recycler<ReadOnlyPooledHeapByteBuf>(ReadOnlyPooledHeapByteBuf::new);
    private ByteBuf parent;

    private ReadOnlyPooledHeapByteBuf() {
        super(0);
    }

    static ReadOnlyPooledHeapByteBuf newInstance(byte[] bytes) {
        ReadOnlyPooledHeapByteBuf instance = RECYCLER.getInstance();
        instance.setRefCnt(1);
        instance.maxCapacity(bytes.length);
        instance.capacity = bytes.length;
        instance.setArray(bytes);
        instance.setIndex(0, bytes.length);
        return instance;
    }

    private int idx(int index) {
        return this.offset + index;
    }

    public ByteBuf slice(int index, int length) {
        this.checkIndex(index, length);
        if (this.maxCapacity() < index + length) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, length, this.maxCapacity()));
        }
        ReadOnlyPooledHeapByteBuf slice = ReadOnlyPooledHeapByteBuf.newInstance(this.array);
        slice.maxCapacity(length);
        slice.capacity = length;
        slice.setIndex(0, length);
        slice.parent = this;
        slice.offset = this.offset + index;
        return slice;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isWritable(int numBytes) {
        return false;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return 1;
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        throw new ReadOnlyBufferException();
    }

    public byte[] array() {
        return this.array;
    }

    public ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuf setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setByte(int index, int value) {
    }

    public ByteBuf setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setShort(int index, int value) {
    }

    public ByteBuf setShortLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setShortLE(int index, int value) {
    }

    public ByteBuf setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setMedium(int index, int value) {
    }

    public ByteBuf setMediumLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setMediumLE(int index, int value) {
    }

    public ByteBuf setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setInt(int index, int value) {
    }

    public ByteBuf setIntLE(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setIntLE(int index, int value) {
    }

    public ByteBuf setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setLong(int index, long value) {
    }

    public ByteBuf setLongLE(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    protected void _setLongLE(int index, long value) {
    }

    public int setBytes(int index, InputStream in, int length) {
        throw new ReadOnlyBufferException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) {
        throw new ReadOnlyBufferException();
    }

    public int setBytes(int index, FileChannel in, long position, int length) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuf duplicate() {
        return this.copy();
    }

    public ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuf asReadOnly() {
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    byte[] allocateArray(int initialCapacity) {
        return new byte[initialCapacity];
    }

    void freeArray(byte[] array) {
    }

    private void setArray(byte[] initialArray) {
        this.array = initialArray;
        this.tmpNioBuf = null;
    }

    public ByteBufAllocator alloc() {
        return ByteBufAllocatorX.INSTANCE;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public ByteBuf unwrap() {
        return null;
    }

    public final boolean isDirect() {
        return false;
    }

    protected byte _getByte(int index) {
        return IOUtil.getByte(this.array, this.idx(index));
    }

    protected short _getShort(int index) {
        return IOUtil.getShort(this.array, this.idx(index));
    }

    protected short _getShortLE(int index) {
        return IOUtil.getShortLE(this.array, this.idx(index));
    }

    protected int _getUnsignedMedium(int index) {
        return IOUtil.getUnsignedMedium(this.array, this.idx(index));
    }

    protected int _getUnsignedMediumLE(int index) {
        return IOUtil.getUnsignedMediumLE(this.array, this.idx(index));
    }

    protected int _getInt(int index) {
        return IOUtil.getInt(this.array, this.idx(index));
    }

    protected int _getIntLE(int index) {
        return IOUtil.getIntLE(this.array, this.idx(index));
    }

    protected long _getLong(int index) {
        return IOUtil.getLong(this.array, this.idx(index));
    }

    protected long _getLongLE(int index) {
        return IOUtil.getLongLE(this.array, this.idx(index));
    }

    public final ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.array, (int)this.idx(index), (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            this.getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, this.array, this.idx(index), length);
        }
        return this;
    }

    public final ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        System.arraycopy(this.array, this.idx(index), dst, dstIndex, length);
        return this;
    }

    public final ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        dst.put(this.array, this.idx(index), dst.remaining());
        return this;
    }

    public final ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        out.write(this.array, this.idx(index), length);
        return this;
    }

    public final int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.getBytes(index, out, length, false);
    }

    private int getBytes(int index, GatheringByteChannel out, int length, boolean internal) throws IOException {
        this.checkIndex(index, length);
        index = this.idx(index);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return out.write((ByteBuffer)tmpBuf.clear().position(index).limit(index + length));
    }

    public final int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        return this.getBytes(index, out, position, length, false);
    }

    private int getBytes(int index, FileChannel out, long position, int length, boolean internal) throws IOException {
        this.checkIndex(index, length);
        index = this.idx(index);
        ByteBuffer tmpBuf = internal ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return out.write((ByteBuffer)tmpBuf.clear().position(index).limit(index + length), position);
    }

    public final ByteBuf copy(int index, int length) {
        return this.slice(index, length);
    }

    public ByteBuf copy() {
        ReadOnlyPooledHeapByteBuf copy = ReadOnlyPooledHeapByteBuf.newInstance(this.array);
        copy.maxCapacity(this.maxCapacity());
        copy.capacity = this.capacity;
        copy.setIndex(this.readerIndex(), this.writerIndex());
        copy.parent = this;
        copy.offset = this.offset;
        return copy;
    }

    public final int nioBufferCount() {
        return 1;
    }

    public final ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    public final ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        index = this.idx(index);
        ByteBuffer buf = ByteBuffer.wrap(this.array, index, length);
        return buf.slice();
    }

    public final ByteBuffer internalNioBuffer(int index, int length) {
        this.checkIndex(index, length);
        index = this.idx(index);
        return (ByteBuffer)this.internalNioBuffer().clear().position(index).limit(index + length);
    }

    public final boolean hasArray() {
        return true;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final boolean hasMemoryAddress() {
        return false;
    }

    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = ByteBuffer.wrap(this.array);
        }
        return tmpNioBuf;
    }

    protected void deallocate() {
        this.freeArray(this.array);
        this.array = EmptyArrays.EMPTY_BYTES;
        this.parent = null;
        this.offset = 0;
        RECYCLER.recycleInstance(this);
    }

    public static void main(String[] args) {
        ByteBuf directBuffer = ByteBufAllocatorX.POOLED.directBuffer(30);
        directBuffer.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        HashSet<ByteBuf> set = new HashSet<ByteBuf>();
        for (int i = 0; i < 30; ++i) {
            set.add(directBuffer.copy());
        }
        long time = System.currentTimeMillis();
        ByteBuf byteBuf = Unpooled.copyLong((long)time);
        long c = byteBuf.getLong(0);
        byte[] requestIdBytes = "requestId".getBytes();
        byte[] requestIdBytesRead = new byte[9];
        ReadOnlyPooledHeapByteBuf byteBuf1 = ReadOnlyPooledHeapByteBuf.newInstance(requestIdBytes);
        ByteBuf b1 = byteBuf1.copy();
        ByteBuf b2 = b1.slice(1, 2);
        ByteBuf b3 = b2.copy();
        ByteBuf b4 = b3.copy(0, 2);
        byteBuf1.readBytes(requestIdBytesRead);
        byteBuf1.release();
        System.out.println("requestIdBytesRead = " + Arrays.toString(requestIdBytesRead));
        byte[] helloBytes = "hello".getBytes();
        byte[] helloBytesRead = new byte[3];
        ReadOnlyPooledHeapByteBuf byteBuf2 = ReadOnlyPooledHeapByteBuf.newInstance(helloBytes);
        byteBuf2.readBytes(helloBytesRead);
        byteBuf2.release();
        System.out.println("helloBytesRead = " + Arrays.toString(helloBytesRead));
    }

    public String toString() {
        return super.toString() + "(" + this.toString(Charset.defaultCharset()) + ")";
    }
}

