/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.ConcurrentReferenceHashMap;
import com.github.netty.core.util.JavaClassFile;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ClassFileMethodToParameterNamesFunction
implements Function<Method, String[]> {
    private static LoggerX logger = LoggerFactoryX.getLogger(ClassFileMethodToParameterNamesFunction.class);
    private static final String[] EMPTY = new String[0];
    private final Map<Class<?>, Map<Member, String[]>> parameterNamesCache = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public static Map<Member, String[]> readParameterNameMap(Class<?> clazz) {
        try {
            JavaClassFile javaClassFile = new JavaClassFile(clazz);
            HashMap<Member, String[]> result = new HashMap<Member, String[]>(6);
            for (JavaClassFile.Member member : javaClassFile.getMethods()) {
                try {
                    Member javaMember = member.toJavaMember();
                    String[] parameterNames = member.getParameterNames();
                    result.put(javaMember, parameterNames);
                }
                catch (Exception e) {
                    logger.warn("readParameterNameMap member = {}, error = {}", (Object)member, (Object)e.toString());
                }
            }
            return result;
        }
        catch (IOException | ClassNotFoundException | IllegalClassFormatException e) {
            return Collections.emptyMap();
        }
    }

    public static void main(String[] args) {
        Map<Member, String[]> memberMap = ClassFileMethodToParameterNamesFunction.readParameterNameMap(ClassFileMethodToParameterNamesFunction.class);
        System.out.println("memberMap = " + memberMap);
    }

    @Override
    public String[] apply(Method method) {
        String[] parameterNames;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isInterface()) {
            return EMPTY;
        }
        Map<Member, String[]> memberMap = this.parameterNamesCache.get(declaringClass);
        if (memberMap == null) {
            memberMap = ClassFileMethodToParameterNamesFunction.readParameterNameMap(declaringClass);
            this.parameterNamesCache.put(declaringClass, memberMap);
        }
        if ((parameterNames = memberMap.get(method)) == null) {
            throw new IllegalStateException("bad method!. object=" + method.getDeclaringClass() + ",method=" + method);
        }
        return parameterNames;
    }
}

