/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final LoggerX LOGGER = LoggerFactoryX.getLogger(ChunkedWriteHandler.class);
    private final Queue<PendingWrite> queue;
    private volatile ChannelHandlerContext ctx;
    private final AtomicBoolean flushIng = new AtomicBoolean(false);
    private LongSupplier maxBufferBytes;
    private final AtomicLong unFlushBytes = new AtomicLong();

    public ChunkedWriteHandler(LongSupplier maxBufferBytes) {
        this(new ArrayDeque<PendingWrite>(), maxBufferBytes);
    }

    public ChunkedWriteHandler(Queue<PendingWrite> queue, LongSupplier maxBufferBytes) {
        this.queue = queue;
        this.maxBufferBytes = maxBufferBytes;
    }

    public void setMaxBufferBytes(LongSupplier maxBufferBytes) {
        this.maxBufferBytes = maxBufferBytes;
    }

    public Collection<PendingWrite> getUnFlushList() {
        return Collections.unmodifiableCollection(this.queue);
    }

    public long getMaxBufferBytes() {
        return this.maxBufferBytes.getAsLong();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void resumeTransfer() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            return;
        }
        if (ctx.executor().inEventLoop()) {
            this.resumeTransfer0(ctx);
        } else {
            ctx.executor().execute(() -> this.resumeTransfer0(ctx));
        }
    }

    private void resumeTransfer0(ChannelHandlerContext ctx) {
        try {
            this.doFlush(ctx);
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception while sending chunks.", e);
        }
    }

    private PendingWrite removeFirst() {
        PendingWrite remove = this.queue.poll();
        if (remove != null) {
            this.unFlushBytes.addAndGet(-remove.bytes);
        }
        return remove;
    }

    private void add(PendingWrite pendingWrite) {
        this.queue.add(pendingWrite);
        this.unFlushBytes.addAndGet(pendingWrite.bytes);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.add(PendingWrite.newInstance(msg, promise));
        if (this.unFlushBytes.get() >= this.maxBufferBytes.getAsLong()) {
            this.doFlush(ctx);
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
        ctx.fireChannelInactive();
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public int unWriteSize() {
        return this.queue.size();
    }

    public void discard(Throwable cause) {
        PendingWrite currentWrite;
        ArrayList<PendingWrite> responseList = new ArrayList<PendingWrite>();
        while ((currentWrite = this.removeFirst()) != null) {
            Object message = currentWrite.msg;
            if (message instanceof ChunkedInput) {
                long inputLength;
                boolean endOfInput;
                ChunkedInput in = (ChunkedInput)message;
                try {
                    endOfInput = in.isEndOfInput();
                    inputLength = in.length();
                    ChunkedWriteHandler.closeInput(in);
                }
                catch (Exception e) {
                    ChunkedWriteHandler.closeInput(in);
                    currentWrite.fail(e);
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn(ChunkedInput.class.getSimpleName() + " failed", e);
                    continue;
                }
                if (!endOfInput) {
                    if (cause == null) {
                        cause = new ClosedChannelException();
                    }
                    currentWrite.fail(cause);
                    continue;
                }
                currentWrite.success(inputLength);
                continue;
            }
            if (message instanceof HttpResponse) {
                responseList.add(currentWrite);
                continue;
            }
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            currentWrite.fail(cause);
        }
        for (PendingWrite httpResponse : responseList) {
            this.add(httpResponse);
        }
    }

    private void doFlush(ChannelHandlerContext ctx) {
        if (this.queue.isEmpty()) {
            ctx.flush();
            return;
        }
        if (this.flushIng.compareAndSet(false, true)) {
            try {
                this.doFlush0(ctx);
            }
            finally {
                this.flushIng.set(false);
            }
        }
    }

    private void doFlush0(ChannelHandlerContext ctx) {
        PendingWrite currentWrite;
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return;
        }
        boolean requiresFlush = true;
        ByteBufAllocator allocator = ctx.alloc();
        while (channel.isWritable() && (currentWrite = this.queue.peek()) != null) {
            if (currentWrite.promise.isDone()) {
                this.removeFirst();
                continue;
            }
            Object pendingMessage = currentWrite.msg;
            if (pendingMessage instanceof ChunkedInput) {
                boolean suspend;
                boolean endOfInput;
                ChunkedInput chunks = (ChunkedInput)pendingMessage;
                Object message = null;
                try {
                    message = chunks.readChunk(allocator);
                    endOfInput = chunks.isEndOfInput();
                    suspend = message == null ? !endOfInput : false;
                }
                catch (Throwable t) {
                    this.removeFirst();
                    if (message != null) {
                        ReferenceCountUtil.release((Object)message);
                    }
                    ChunkedWriteHandler.closeInput(chunks);
                    currentWrite.fail(t);
                    break;
                }
                if (suspend) break;
                if (message == null) {
                    message = Unpooled.EMPTY_BUFFER;
                }
                ChannelFuture f = ctx.writeAndFlush(message);
                if (endOfInput) {
                    this.removeFirst();
                    if (f.isDone()) {
                        ChunkedWriteHandler.handleEndOfInputFuture(f, currentWrite);
                    } else {
                        f.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) {
                                ChunkedWriteHandler.handleEndOfInputFuture(future, currentWrite);
                            }
                        });
                    }
                } else {
                    boolean resume;
                    boolean bl = resume = !channel.isWritable();
                    if (f.isDone()) {
                        this.handleFuture(f, currentWrite, resume);
                    } else {
                        f.addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) {
                                ChunkedWriteHandler.this.handleFuture(future, currentWrite, resume);
                            }
                        });
                    }
                }
                requiresFlush = false;
            } else {
                if (pendingMessage instanceof Flushable) {
                    try {
                        ((Flushable)pendingMessage).flush();
                    }
                    catch (IOException e) {
                        LOGGER.warn(pendingMessage.getClass().getSimpleName() + " flush error", e);
                    }
                }
                this.removeFirst();
                ctx.write(pendingMessage, currentWrite.promise);
                currentWrite.recycle();
                requiresFlush = true;
            }
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        if (requiresFlush) {
            ctx.flush();
        }
    }

    private static void handleEndOfInputFuture(ChannelFuture future, PendingWrite currentWrite) {
        ChunkedInput input = (ChunkedInput)currentWrite.msg;
        if (!future.isSuccess()) {
            ChunkedWriteHandler.closeInput(input);
            currentWrite.fail(future.cause());
        } else {
            long inputProgress = input.progress();
            long inputLength = input.length();
            ChunkedWriteHandler.closeInput(input);
            currentWrite.progress(inputProgress, inputLength);
            currentWrite.success(inputLength);
        }
    }

    private void handleFuture(ChannelFuture future, PendingWrite currentWrite, boolean resume) {
        ChunkedInput input = (ChunkedInput)currentWrite.msg;
        if (!future.isSuccess()) {
            ChunkedWriteHandler.closeInput(input);
            currentWrite.fail(future.cause());
        } else {
            currentWrite.progress(input.progress(), input.length());
            if (resume && future.channel().isWritable()) {
                this.resumeTransfer();
            }
        }
    }

    private static void closeInput(ChunkedInput<?> chunks) {
        block2: {
            try {
                chunks.close();
            }
            catch (Throwable t) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Failed to close a chunked input.", t);
            }
        }
    }

    public String toString() {
        return "ChunkedWriteHandler{maxBufferBytes=" + this.maxBufferBytes + ", unFlushBytes=" + this.unFlushBytes + ", queueSize=" + this.queue.size() + ", ctx=" + this.ctx + '}';
    }

    private static final class PendingWrite
    implements Recyclable {
        private static final Recycler<PendingWrite> RECYCLER = new Recycler<PendingWrite>(PendingWrite::new);
        Object msg;
        ChannelPromise promise;
        long bytes;

        PendingWrite() {
        }

        public static PendingWrite newInstance(Object msg, ChannelPromise promise) {
            PendingWrite instance = RECYCLER.getInstance();
            instance.msg = msg;
            instance.promise = promise;
            instance.bytes = msg instanceof ByteBuf ? (long)((ByteBuf)msg).readableBytes() : (msg instanceof ByteBuffer ? (long)((ByteBuffer)msg).remaining() : (msg instanceof ByteBufHolder ? (long)((ByteBufHolder)msg).content().readableBytes() : (msg instanceof ChunkedInput ? Math.max(((ChunkedInput)msg).length(), 0L) : (msg instanceof FileRegion ? ((FileRegion)msg).count() - ((FileRegion)msg).position() : 0L))));
            return instance;
        }

        public String toString() {
            return "PendingWrite{msg=" + this.msg + ", bytes=" + this.bytes + '}';
        }

        void fail(Throwable cause) {
            ReferenceCountUtil.release((Object)this.msg);
            this.promise.tryFailure(cause);
            this.recycle();
        }

        void success(long total) {
            if (this.promise.isDone()) {
                return;
            }
            this.progress(total, total);
            this.promise.trySuccess();
            this.recycle();
        }

        void progress(long progress, long total) {
            if (this.promise instanceof ChannelProgressivePromise) {
                ((ChannelProgressivePromise)this.promise).tryProgress(progress, total);
            }
        }

        @Override
        public void recycle() {
            this.msg = null;
            this.promise = null;
            RECYCLER.recycleInstance(this);
        }
    }
}

