/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ApplicationX {
    private static final AtomicInteger SHUTDOWN_HOOK_ID_INCR = new AtomicInteger();
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final PropertyDescriptor[] EMPTY_DESCRIPTOR_ARRAY = new PropertyDescriptor[0];
    private static final Constructor<ConcurrentMap> CONCURRENT_REFERENCE_MAP_CONSTRUCTOR = ApplicationX.getAnyConstructor(new Class[]{Integer.TYPE}, "com.github.netty.core.util.ConcurrentReferenceHashMap", "org.springframework.util.ConcurrentReferenceHashMap", "org.hibernate.validator.internal.util.ConcurrentReferenceHashMap");
    private static final Map<Class, Boolean> AUTOWIRED_ANNOTATION_CACHE_MAP = ApplicationX.newConcurrentReferenceMap(128);
    private static final Map<Class, Boolean> QUALIFIER_ANNOTATION_CACHE_MAP = ApplicationX.newConcurrentReferenceMap(128);
    private static final Map<Class, Boolean> FACTORY_METHOD_ANNOTATION_CACHE_MAP = ApplicationX.newConcurrentReferenceMap(32);
    private static final Map<Class, PropertyDescriptor[]> PROPERTY_DESCRIPTOR_CACHE_MAP = ApplicationX.newConcurrentReferenceMap(128);
    private static final Map<Class, Method[]> DECLARED_METHODS_CACHE_MAP = ApplicationX.newConcurrentReferenceMap(128);
    private static final OrderComparator COMPARATOR = new OrderComparator(new LinkedHashSet<Class<? extends Annotation>>(Collections.singletonList(Order.class)));
    private BiPredicate<ClassLoader, URL> resourceLoaderUrlFilter = (classLoader, url) -> !this.isJavaLib((URL)url);
    private Supplier<ClassLoader> resourceLoader;
    private Function<BeanDefinition, String> beanNameGenerator = new DefaultBeanNameGenerator(this);
    private final Collection<Class<? extends Annotation>> initMethodAnnotations = new LinkedHashSet<Class>(Arrays.asList(PostConstruct.class));
    private final Collection<Class<? extends Annotation>> destroyMethodAnnotations = new LinkedHashSet<Class>(Arrays.asList(PreDestroy.class));
    private final Collection<Class<? extends Annotation>> scannerAnnotations = new LinkedHashSet<Class>(Arrays.asList(Resource.class, Component.class));
    private final Collection<Class<? extends Annotation>> autowiredAnnotations = new LinkedHashSet<Class>(Arrays.asList(Resource.class, Autowired.class));
    private final Collection<Class<? extends Annotation>> qualifierAnnotations = new LinkedHashSet<Class>(Arrays.asList(Resource.class, Qualifier.class));
    private final Collection<Class<? extends Annotation>> orderedAnnotations = new LinkedHashSet<Class>(Arrays.asList(Order.class));
    private final Collection<Class<? extends Annotation>> factoryMethodAnnotations = new LinkedHashSet<Class>(Arrays.asList(Bean.class));
    private final Collection<BeanPostProcessor> beanPostProcessors = new TreeSet<Object>(new OrderComparator(this.orderedAnnotations));
    private final Collection<String> beanSkipLifecycles = new LinkedHashSet<String>(8);
    private final Map<Class, String[]> beanNameMap = new ConcurrentHashMap<Class, String[]>(64);
    private final Map<String, String> beanAliasMap = new ConcurrentHashMap<String, String>(6);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(64);
    private final Map<String, Object> singletonObjects = new ConcurrentHashMap<String, Object>(64);
    private final Set<String> singletonsCurrentlyInCreation = Collections.newSetFromMap(new ConcurrentHashMap(16));
    private final Map<Class, AbstractBeanFactory> beanFactoryMap = new LinkedHashMap<Class, AbstractBeanFactory>(8);
    private final AbstractBeanFactory defaultBeanFactory = new DefaultBeanFactory();
    private final Scanner scanner = new Scanner();
    private final long timestamp = System.currentTimeMillis();

    public ApplicationX() {
        this(ApplicationX.class::getClassLoader);
    }

    public ApplicationX(Supplier<ClassLoader> resourceLoader) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader);
        this.addClasses(this.initMethodAnnotations, "javax.annotation.PostConstruct");
        this.addClasses(this.destroyMethodAnnotations, "javax.annotation.PreDestroy");
        this.addClasses(this.scannerAnnotations, "javax.annotation.Resource", "org.springframework.stereotype.Component");
        this.addClasses(this.autowiredAnnotations, "javax.annotation.Resource", "javax.inject.Inject", "org.springframework.beans.factory.annotation.Autowired");
        this.addClasses(this.qualifierAnnotations, "javax.annotation.Resource", "org.springframework.beans.factory.annotation.Qualifier");
        this.addClasses(this.orderedAnnotations, "org.springframework.core.annotation.Order");
        this.addSingletonBean(this);
        this.addBeanPostProcessor(new RegisteredBeanPostProcessor(this));
        this.addBeanPostProcessor(new AutowiredConstructorPostProcessor(this));
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownHook, "app.shutdownHook-" + SHUTDOWN_HOOK_ID_INCR.getAndIncrement()));
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        ApplicationX app = new ApplicationX();
        System.out.println("new = " + (System.currentTimeMillis() - startTime) + "/ms");
        startTime = System.currentTimeMillis();
        int count = app.scanner("com.github.netty").inject();
        System.out.println("scanner = " + (System.currentTimeMillis() - startTime) + "/ms");
        System.out.println("count = " + count);
        System.out.println("app = " + app);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void addClasses(Collection annotationList, String ... classNames) {
        ClassLoader classLoader = this.resourceLoader.get();
        for (String className : classNames) {
            try {
                annotationList.add(Class.forName(className, false, classLoader));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object addSingletonBean(Object instance) {
        return this.addSingletonBean(instance, null, true, null);
    }

    public Object addSingletonBean(Object instance, String beanName) {
        return this.addSingletonBean(instance, beanName, true, null);
    }

    public Object addSingletonBean(Object instance, String beanName, boolean isLifecycle) {
        return this.addSingletonBean(instance, beanName, isLifecycle, null);
    }

    public Object addSingletonBean(Object instance, String beanName, boolean isLifecycle, BiConsumer<String, BeanDefinition> beanDefinitionConfig) {
        Class<?> beanType = instance.getClass();
        BeanDefinition definition = this.newBeanDefinition(beanType);
        definition.setBeanSupplier(() -> instance);
        if (!isLifecycle) {
            this.beanSkipLifecycles.add(beanName);
        }
        if (beanName == null) {
            beanName = this.beanNameGenerator.apply(definition);
        }
        if (beanDefinitionConfig != null) {
            beanDefinitionConfig.accept(beanName, definition);
        }
        definition.setScope("singleton");
        this.addBeanDefinition(beanName, definition);
        Boolean oldInstance = this.singletonObjects.remove(beanName, instance);
        if (!definition.isLazyInit()) {
            this.getBean(beanName, null, true);
        }
        return oldInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String name, String alias) {
        Objects.requireNonNull(name, "'name' must not be empty");
        Objects.requireNonNull(alias, "'alias' must not be empty");
        Map<String, String> map = this.beanAliasMap;
        synchronized (map) {
            if (alias.equals(name)) {
                this.beanAliasMap.remove(alias);
            } else {
                String registeredName = this.beanAliasMap.get(alias);
                if (registeredName != null && registeredName.equals(name)) {
                    return;
                }
                if (this.hasAlias(alias, name)) {
                    throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "': Circular reference - '" + name + "' is a direct or indirect alias for '" + alias + "' already");
                }
                this.beanAliasMap.put(alias, name);
            }
        }
    }

    public boolean hasAlias(String name, String alias) {
        for (Map.Entry<String, String> entry : this.beanAliasMap.entrySet()) {
            String registeredAlias;
            String registeredName = entry.getValue();
            if (!registeredName.equals(name) || !(registeredAlias = entry.getKey()).equals(alias) && !this.hasAlias(registeredAlias, alias)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String alias) {
        Map<String, String> map = this.beanAliasMap;
        synchronized (map) {
            String name = this.beanAliasMap.remove(alias);
            if (name == null) {
                throw new IllegalStateException("No alias '" + alias + "' registered");
            }
        }
    }

    public boolean isAlias(String name) {
        return this.beanAliasMap.containsKey(name);
    }

    public boolean isSingletonCurrentlyInCreation(String beanName) {
        return this.singletonsCurrentlyInCreation.contains(beanName);
    }

    protected void addSingleton(String beanName, Object singletonObject) {
        this.singletonObjects.put(beanName, singletonObject);
    }

    public String getBeanName(String beanNameOrAlias) {
        String resolvedName;
        String canonicalName = beanNameOrAlias;
        do {
            if ((resolvedName = this.beanAliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> map = this.beanAliasMap;
        synchronized (map) {
            this.retrieveAliases(name, result);
        }
        return result.toArray(new String[0]);
    }

    private void retrieveAliases(String name, List<String> result) {
        for (Map.Entry<String, String> entry : this.beanAliasMap.entrySet()) {
            String alias = entry.getKey();
            String registeredName = entry.getValue();
            if (!registeredName.equals(name)) continue;
            result.add(alias);
            this.retrieveAliases(alias, result);
        }
    }

    protected BiConsumer<URL, String> newScannerConsumer(ClassLoader classLoader, ScannerResult result) {
        return (url, className) -> {
            try {
                result.classCount.incrementAndGet();
                Class<?> clazz = Class.forName(className, false, classLoader);
                if (clazz.isAnnotation()) {
                    return;
                }
                if (clazz.isInterface()) {
                    return;
                }
                if (!ApplicationX.isExistAnnotation(clazz, this.scannerAnnotations, result.scannerAnnotationCacheMap)) {
                    return;
                }
                BeanDefinition definition = this.newBeanDefinition(clazz);
                String beanName = this.beanNameGenerator.apply(definition);
                result.beanDefinitionMap.put(beanName, definition);
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
                // empty catch block
            }
        };
    }

    public ScannerResult scanner(ClassLoader classLoader, boolean onlyInMyProject) {
        return this.scanner(classLoader, onlyInMyProject, new ScannerResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannerResult scanner(ClassLoader classLoader, boolean onlyInMyProject, ScannerResult result) {
        result.scannerBeginTimestamp = System.currentTimeMillis();
        try {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (onlyInMyProject) {
                result.classLoaders.add(classLoader);
                BiConsumer<URL, String> consumer = this.newScannerConsumer(classLoader, result);
                try {
                    for (String rootPackage : this.scanner.getRootPackages()) {
                        this.scanner.doScan(rootPackage, classLoader, consumer);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("scanner classLoader=" + classLoader + ",error=" + e, e);
                }
                ScannerResult e = result;
                return e;
            }
            for (Object userLoader = classLoader; userLoader != null && userLoader != systemClassLoader; userLoader = ((ClassLoader)userLoader).getParent()) {
                URL[] urls;
                if (!(userLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)userLoader).getURLs()) == null) continue;
                for (URL url : urls) {
                    result.addClassUrl((ClassLoader)userLoader, url);
                }
            }
            for (URL url : result.tempUrls) {
                BiConsumer<URL, String> consumer = this.newScannerConsumer(classLoader, result);
                try {
                    for (String rootPackage : this.scanner.getRootPackages()) {
                        this.scanner.doScan(rootPackage, null, url, consumer);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("scanner userClassLoader error. url=" + url + ",error=" + e, e);
                }
            }
            result.tempUrls.clear();
            String cp = System.getProperty("java.class.path");
            if (cp != null) {
                while (cp.length() > 0) {
                    String pathElem;
                    int pathSepIdx = cp.indexOf(File.pathSeparatorChar);
                    if (pathSepIdx < 0) {
                        pathElem = cp;
                        this.addClassURL(result, systemClassLoader, pathElem);
                        break;
                    }
                    if (pathSepIdx > 0) {
                        pathElem = cp.substring(0, pathSepIdx);
                        this.addClassURL(result, systemClassLoader, pathElem);
                    }
                    cp = cp.substring(pathSepIdx + 1);
                }
                for (URL url : result.tempUrls) {
                    BiConsumer<URL, String> consumer = this.newScannerConsumer(systemClassLoader, result);
                    try {
                        for (String rootPackage : this.scanner.getRootPackages()) {
                            this.scanner.doScan(rootPackage, null, url, consumer);
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("scanner systemClassLoader error. url=" + url + ",error=" + e, e);
                    }
                }
                result.tempUrls.clear();
            }
        }
        finally {
            result.scannerEndTimestamp = System.currentTimeMillis();
        }
        return result;
    }

    protected void addClassURL(ScannerResult result, ClassLoader loader, String path) {
        try {
            URL url = new File(path).getCanonicalFile().toURI().toURL();
            result.addClassUrl(loader, url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BiPredicate<ClassLoader, URL> getResourceLoaderUrlFilter() {
        return this.resourceLoaderUrlFilter;
    }

    public void setResourceLoaderUrlFilter(BiPredicate<ClassLoader, URL> resourceLoaderUrlFilter) {
        this.resourceLoaderUrlFilter = resourceLoaderUrlFilter;
    }

    protected boolean isJavaLib(URL url) {
        String[] javaPaths;
        String urlStr = url.toString();
        for (String javaPath : javaPaths = new String[]{"/jre/lib/"}) {
            if (!urlStr.contains(javaPath)) continue;
            return true;
        }
        return false;
    }

    public ScannerResult scanner(String ... rootPackage) {
        return this.scanner(false, rootPackage);
    }

    public ScannerResult scanner(boolean onlyInMyProject, String ... rootPackage) {
        this.addScanPackage(rootPackage);
        ClassLoader loader = this.resourceLoader.get();
        return this.scanner(loader, onlyInMyProject);
    }

    public ApplicationX addExcludesPackage(String ... excludesPackages) {
        if (excludesPackages != null) {
            this.scanner.getExcludes().addAll(Arrays.asList(excludesPackages));
        }
        return this;
    }

    public ApplicationX addScanPackage(String ... rootPackages) {
        if (rootPackages != null) {
            this.scanner.getRootPackages().addAll(Arrays.asList(rootPackages));
        }
        return this;
    }

    public ApplicationX removeScanPackage(String ... rootPackages) {
        if (rootPackages != null) {
            this.scanner.getRootPackages().removeAll(Arrays.asList(rootPackages));
        }
        return this;
    }

    public ApplicationX addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.beanPostProcessors.add(beanPostProcessor);
        return this;
    }

    public ApplicationX addBeanFactory(Class type, AbstractBeanFactory beanFactory) {
        this.addSingletonBean(beanFactory);
        this.beanFactoryMap.put(type, beanFactory);
        return this;
    }

    public BeanDefinition[] getBeanDefinitions(Class clazz) {
        String[] beanNames = this.beanNameMap.get(clazz);
        BeanDefinition[] beanDefinitions = new BeanDefinition[beanNames.length];
        for (int i = 0; i < beanNames.length; ++i) {
            beanDefinitions[i] = this.getBeanDefinition(beanNames[i]);
        }
        return beanDefinitions;
    }

    public BeanDefinition getBeanDefinition(String beanName) {
        BeanDefinition definition = this.beanDefinitionMap.get(beanName);
        return definition;
    }

    public String[] getBeanNamesForType(Class clazz) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitionMap.entrySet()) {
            BeanDefinition definition = entry.getValue();
            if (!clazz.isAssignableFrom(definition.getBeanClassIfResolve(this.resourceLoader))) continue;
            String beanName = entry.getKey();
            result.add(beanName);
        }
        return result.toArray(new String[0]);
    }

    public <T> T getBean(Class<T> clazz) {
        return this.getBean(clazz, null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getBean(Class<T> clazz, Object[] args, boolean required) {
        String beanName;
        String[] beanNames = this.getBeanNamesForType(clazz);
        if (beanNames.length == 0) {
            if (!required) return null;
            throw new IllegalStateException("Not found bean. by type=" + clazz);
        }
        if (beanNames.length == 1) {
            beanName = beanNames[0];
            return this.getBean(beanName, args, required);
        } else {
            ArrayList<String> primaryBeanNameList = new ArrayList<String>(beanNames.length);
            ArrayList<String> nonPrimaryBeanNameList = new ArrayList<String>(beanNames.length);
            for (String eachBeanName : beanNames) {
                BeanDefinition definition = this.getBeanDefinition(eachBeanName);
                if (definition.isPrimary()) {
                    primaryBeanNameList.add(eachBeanName);
                    continue;
                }
                nonPrimaryBeanNameList.add(eachBeanName);
            }
            if (primaryBeanNameList.isEmpty()) {
                if (nonPrimaryBeanNameList.size() != 1) throw new IllegalStateException("Found more bean. you can Annotation @Primary. beanNames=" + nonPrimaryBeanNameList);
                beanName = (String)nonPrimaryBeanNameList.get(0);
                return this.getBean(beanName, args, required);
            } else {
                if (primaryBeanNameList.size() != 1) throw new IllegalStateException("Found more primary bean. beanNames=" + primaryBeanNameList);
                beanName = (String)primaryBeanNameList.get(0);
            }
        }
        return this.getBean(beanName, args, required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getBean(String beanNameOrAlias, Object[] args, boolean required) {
        String beanName = this.getBeanName(beanNameOrAlias);
        BeanDefinition definition = this.beanDefinitionMap.get(beanName);
        if (definition == null) {
            if (required) {
                throw new IllegalStateException("getBean error. bean is not definition. beanName=" + beanName);
            }
            return null;
        }
        boolean isSingleton = definition.isSingleton();
        Object instance = null;
        if (isSingleton) {
            instance = this.singletonObjects.get(beanName);
        }
        if (instance == null) {
            if (isSingleton) {
                this.beforeSingletonCreation(beanName);
            }
            try {
                Class beanClass = definition.getBeanClassIfResolve(this.resourceLoader);
                AbstractBeanFactory beanFactory = this.getBeanFactory(beanClass);
                instance = beanFactory.createBean(beanName, definition, args);
                if (isSingleton) {
                    this.addSingleton(beanName, instance);
                }
            }
            finally {
                if (isSingleton) {
                    this.afterSingletonCreation(beanName);
                }
            }
        }
        return (T)instance;
    }

    public <T> T getBean(String beanName) {
        return this.getBean(beanName, null, true);
    }

    public <T> T getBean(String beanName, Object[] args) {
        return this.getBean(beanName, args, true);
    }

    public <T> List<T> getBeanForAnnotation(Class<? extends Annotation> ... annotationType) {
        ArrayList<T> result = new ArrayList<T>();
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitionMap.entrySet()) {
            T bean;
            String beanName = entry.getKey();
            BeanDefinition definition = entry.getValue();
            Class beanClass = definition.getBeanClassIfResolve(this.resourceLoader);
            Annotation annotation = ApplicationX.findAnnotation(beanClass, Arrays.asList(annotationType));
            if (annotation == null || (bean = this.getBean(beanName, null, false)) == null) continue;
            result.add(bean);
        }
        return result;
    }

    public <T> List<T> getBeanForType(Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (String beanName : this.getBeanNamesForType(clazz)) {
            T bean = this.getBean(beanName, null, false);
            if (bean == null) continue;
            result.add(bean);
        }
        return result;
    }

    public boolean containsBean(String name) {
        String beanName = this.getBeanName(name);
        return this.singletonObjects.containsKey(beanName) || this.beanDefinitionMap.containsKey(beanName);
    }

    public boolean containsInstance(String name) {
        String beanName = this.getBeanName(name);
        return this.singletonObjects.containsKey(beanName);
    }

    public BeanDefinition newBeanDefinition(Class beanType) {
        return this.newBeanDefinition(beanType, beanType);
    }

    public BeanDefinition newBeanDefinition(Class beanType, AnnotatedElement annotatedElement) {
        Lazy lazyAnnotation = annotatedElement.getAnnotation(Lazy.class);
        Scope scopeAnnotation = annotatedElement.getAnnotation(Scope.class);
        Primary primaryAnnotation = annotatedElement.getAnnotation(Primary.class);
        BeanDefinition definition = new BeanDefinition();
        definition.setBeanClass(beanType);
        definition.setBeanClassName(beanType.getName());
        definition.setScope(scopeAnnotation == null ? "singleton" : scopeAnnotation.value());
        definition.setLazyInit(lazyAnnotation != null && lazyAnnotation.value());
        definition.setInitMethodName(ApplicationX.findMethodNameByNoArgs(beanType, this.initMethodAnnotations));
        definition.setDestroyMethodName(ApplicationX.findMethodNameByNoArgs(beanType, this.destroyMethodAnnotations));
        definition.setPrimary(primaryAnnotation != null);
        return definition;
    }

    public BeanDefinition addBeanDefinition(String beanName, BeanDefinition definition) {
        return this.addBeanDefinition(beanName, definition, this.beanNameMap, this.beanDefinitionMap);
    }

    public BeanDefinition addBeanDefinition(String beanName, BeanDefinition definition, Map<Class, String[]> beanNameMap, Map<String, BeanDefinition> beanDefinitionMap) {
        Class beanClass = definition.getBeanClassIfResolve(this.resourceLoader);
        String[] oldBeanNames = beanNameMap.get(beanClass);
        LinkedHashSet<String> nameSet = oldBeanNames != null ? new LinkedHashSet<String>(Arrays.asList(oldBeanNames)) : new LinkedHashSet(1);
        nameSet.add(beanName);
        beanNameMap.put(beanClass, nameSet.toArray(new String[0]));
        return beanDefinitionMap.put(beanName, definition);
    }

    protected void afterSingletonCreation(String beanName) {
        if (!this.singletonsCurrentlyInCreation.remove(beanName)) {
            throw new IllegalStateException("Singleton '" + beanName + "' isn't currently in creation");
        }
    }

    protected void beforeSingletonCreation(String beanName) {
        if (!this.singletonsCurrentlyInCreation.add(beanName)) {
            throw new IllegalStateException("BeanCurrentlyInCreationException " + beanName);
        }
    }

    protected int findAutowireType(AnnotatedElement field) {
        String autowiredBeanName;
        Annotation qualifierAnnotation = ApplicationX.findDeclaredAnnotation(field, this.qualifierAnnotations, QUALIFIER_ANNOTATION_CACHE_MAP);
        int autowireType = qualifierAnnotation != null ? (Objects.equals(Resource.class.getSimpleName(), qualifierAnnotation.annotationType().getSimpleName()) ? ((autowiredBeanName = ApplicationX.getAnnotationValue(qualifierAnnotation, "name", String.class)) == null || autowiredBeanName.isEmpty() ? 2 : 1) : 1) : 2;
        return autowireType;
    }

    protected Object initializeBean(String beanName, BeanWrapper beanWrapper, BeanDefinition definition) throws IllegalStateException {
        Object bean = beanWrapper.getWrappedInstance();
        this.invokeBeanAwareMethods(beanName, bean, definition);
        Object wrappedBean = bean;
        wrappedBean = this.applyBeanBeforeInitialization(beanName, wrappedBean);
        this.invokeBeanInitialization(beanName, bean, definition);
        wrappedBean = this.applyBeanAfterInitialization(beanName, wrappedBean);
        return wrappedBean;
    }

    protected void invokeBeanAwareMethods(String beanName, Object bean, BeanDefinition definition) throws IllegalStateException {
        if (bean instanceof Aware) {
            if (bean instanceof BeanNameAware) {
                ((BeanNameAware)bean).setBeanName(beanName);
            }
            if (bean instanceof ApplicationAware) {
                ((ApplicationAware)bean).setApplication(this);
            }
        }
    }

    protected Object applyBeanBeforeInitialization(String beanName, Object bean) throws IllegalStateException {
        Object result = bean;
        for (BeanPostProcessor processor : new ArrayList<BeanPostProcessor>(this.beanPostProcessors)) {
            Object current;
            try {
                current = processor.postProcessBeforeInitialization(result, beanName);
            }
            catch (Exception e) {
                throw new IllegalStateException("applyBeanBeforeInitialization error=" + e, e);
            }
            if (current == null) {
                return result;
            }
            result = current;
        }
        return result;
    }

    private Object applyBeanAfterInitialization(String beanName, Object bean) throws IllegalStateException {
        Object result = bean;
        for (BeanPostProcessor processor : new ArrayList<BeanPostProcessor>(this.beanPostProcessors)) {
            Object current;
            try {
                current = processor.postProcessAfterInitialization(result, beanName);
            }
            catch (Exception e) {
                throw new IllegalStateException("applyBeanAfterInitialization error=" + e, e);
            }
            if (current == null) {
                return result;
            }
            result = current;
        }
        return result;
    }

    private AbstractBeanFactory getBeanFactory(Class beanType) {
        AbstractBeanFactory beanFactory = null;
        if (this.beanFactoryMap.size() > 0) {
            for (Class type = beanType; type != null && (beanFactory = this.beanFactoryMap.get(type)) == null; type = type.getSuperclass()) {
            }
        }
        if (beanFactory == null) {
            beanFactory = this.defaultBeanFactory;
        }
        return beanFactory;
    }

    private static boolean isAbstract(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isInterface(modifier) || Modifier.isAbstract(modifier);
    }

    private static Boolean isExistAnnotation0(Class clazz, Collection<Class<? extends Annotation>> finds, Map<Class, Boolean> cacheMap) {
        Boolean exist = cacheMap.get(clazz);
        if (finds.contains(clazz)) {
            exist = Boolean.TRUE;
        } else if (exist == null) {
            Annotation annotation;
            exist = Boolean.FALSE;
            cacheMap.put(clazz, exist);
            LinkedList<Annotation> queue = new LinkedList<Annotation>(Arrays.asList(clazz.getDeclaredAnnotations()));
            while ((annotation = (Annotation)queue.poll()) != null) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType == clazz) continue;
                if (finds.contains(annotationType)) {
                    exist = Boolean.TRUE;
                    break;
                }
                if (!ApplicationX.isExistAnnotation0(annotationType, finds, cacheMap).booleanValue()) continue;
                exist = Boolean.TRUE;
                break;
            }
        }
        cacheMap.put(clazz, exist);
        return exist;
    }

    public static boolean isExistAnnotation(Class clazz, Collection<Class<? extends Annotation>> finds, Map<Class, Boolean> cacheMap) {
        Boolean existAnnotation = cacheMap.get(clazz);
        if (existAnnotation == null) {
            HashMap<Class, Boolean> tempCacheMap = new HashMap<Class, Boolean>();
            existAnnotation = ApplicationX.isExistAnnotation0(clazz, finds, tempCacheMap);
            cacheMap.putAll(tempCacheMap);
        }
        return existAnnotation;
    }

    public String toString() {
        return this.scanner.getRootPackages() + " @ size = " + this.beanDefinitionMap.size();
    }

    private static <T> T getAnnotationValue(Annotation annotation, String[] fieldNames, Class<T> type) {
        for (String fieldName : fieldNames) {
            T value = ApplicationX.getAnnotationValue(annotation, fieldName, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static <T> T getAnnotationValue(Annotation annotation, String fieldName, Class<T> type) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(fieldName, new Class[0]);
            Object value = method.invoke((Object)annotation, new Object[0]);
            if (value != null && type.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    private static Annotation findDeclaredAnnotation(AnnotatedElement element, Collection<Class<? extends Annotation>> finds, Map<Class, Boolean> cacheMap) {
        Annotation[] fieldAnnotations;
        for (Annotation annotation : fieldAnnotations = element.getDeclaredAnnotations()) {
            boolean existAnnotation = ApplicationX.isExistAnnotation(annotation.annotationType(), finds, cacheMap);
            if (!existAnnotation) continue;
            return annotation;
        }
        return null;
    }

    private static Annotation findAnnotation(Class rootClass, Collection<Class<? extends Annotation>> finds) {
        Annotation result;
        if (rootClass == null) {
            return null;
        }
        for (Class clazz = rootClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Class<? extends Annotation> find : finds) {
                result = clazz.getAnnotation(find);
                if (null == result) continue;
                return result;
            }
        }
        Collection<Class> interfaces = ApplicationX.getInterfaces(rootClass);
        Iterator<Class<? extends Annotation>> iterator = interfaces.iterator();
        while (iterator.hasNext()) {
            Class<? extends Annotation> i;
            for (Class<? extends Annotation> clazz = i = iterator.next(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Class<? extends Annotation> find : finds) {
                    result = clazz.getAnnotation(find);
                    if (null == result) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private static Collection<Class> getInterfaces(Class sourceClass) {
        LinkedHashSet<Class> interfaceList = new LinkedHashSet<Class>();
        if (sourceClass.isInterface()) {
            interfaceList.add(sourceClass);
        }
        for (Class currClass = sourceClass; currClass != null && currClass != Object.class; currClass = currClass.getSuperclass()) {
            Collections.addAll(interfaceList, currClass.getInterfaces());
        }
        return interfaceList;
    }

    private static boolean isSimpleProperty(Class<?> clazz) {
        return ApplicationX.isSimpleValueType(clazz) || clazz.isArray() && ApplicationX.isSimpleValueType(clazz.getComponentType());
    }

    private static boolean isSimpleValueType(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Character.class || Enum.class.isAssignableFrom(clazz) || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || URI.class == clazz || URL.class == clazz || Locale.class == clazz || Class.class == clazz;
    }

    private void shutdownHook() {
        for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitionMap.entrySet()) {
            String beanName = entry.getKey();
            BeanDefinition definition = entry.getValue();
            try {
                Object bean;
                if (!this.containsInstance(beanName) || !this.isLifecycle(beanName) || (bean = this.getBean(beanName, null, false)) == null) continue;
                this.invokeBeanDestroy(beanName, bean, definition);
            }
            catch (Exception exception) {}
        }
    }

    private void invokeBeanDestroy(String beanName, Object bean, BeanDefinition definition) throws IllegalStateException {
        String destroyMethodName;
        boolean isDisposableBean = bean instanceof DisposableBean;
        if (isDisposableBean) {
            try {
                ((DisposableBean)bean).destroy();
            }
            catch (Exception e) {
                throw new IllegalStateException("invokeBeanDestroy destroy beanName=" + beanName + ".error=" + e, e);
            }
        }
        if (!((destroyMethodName = definition.getDestroyMethodName()) == null || destroyMethodName.length() <= 0 || isDisposableBean && "destroy".equals(destroyMethodName))) {
            Class beanClass = definition.getBeanClassIfResolve(this.resourceLoader);
            try {
                beanClass.getMethod(destroyMethodName, new Class[0]).invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("invokeBeanDestroy destroyMethodName beanName=" + beanName + ",destroyMethodName" + destroyMethodName + ",error=" + e, e);
            }
        }
    }

    private void invokeBeanInitialization(String beanName, Object bean, BeanDefinition definition) throws IllegalStateException {
        String initMethodName;
        boolean isInitializingBean = bean instanceof InitializingBean;
        if (isInitializingBean) {
            try {
                ((InitializingBean)bean).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new IllegalStateException("invokeBeanInitialization afterPropertiesSet beanName=" + beanName + ".error=" + e, e);
            }
        }
        if (!((initMethodName = definition.getInitMethodName()) == null || initMethodName.length() <= 0 || isInitializingBean && "afterPropertiesSet".equals(initMethodName))) {
            Class beanClass = definition.getBeanClassIfResolve(this.resourceLoader);
            try {
                beanClass.getMethod(initMethodName, new Class[0]).invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("invokeBeanInitialization initMethodName beanName=" + beanName + ",initMethodName" + initMethodName + ",error=" + e, e);
            }
        }
    }

    public String[] getBeanNames() {
        return this.beanDefinitionMap.keySet().toArray(new String[0]);
    }

    public Collection<Class<? extends Annotation>> getInitMethodAnnotations() {
        return this.initMethodAnnotations;
    }

    public Collection<Class<? extends Annotation>> getScannerAnnotations() {
        return this.scannerAnnotations;
    }

    public Collection<Class<? extends Annotation>> getAutowiredAnnotations() {
        return this.autowiredAnnotations;
    }

    public Collection<Class<? extends Annotation>> getQualifierAnnotations() {
        return this.qualifierAnnotations;
    }

    public Collection<Class<? extends Annotation>> getDestroyMethodAnnotations() {
        return this.destroyMethodAnnotations;
    }

    public Collection<Class<? extends Annotation>> getOrderedAnnotations() {
        return this.orderedAnnotations;
    }

    public Collection<Class<? extends Annotation>> getFactoryMethodAnnotations() {
        return this.factoryMethodAnnotations;
    }

    public Collection<BeanPostProcessor> getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    public Collection<String> getBeanSkipLifecycles() {
        return this.beanSkipLifecycles;
    }

    public Function<BeanDefinition, String> getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setBeanNameGenerator(Function<BeanDefinition, String> beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    public boolean isLifecycle(String beanName) {
        return !this.beanSkipLifecycles.contains(beanName);
    }

    public Supplier<ClassLoader> getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(Supplier<ClassLoader> resourceLoader) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader);
    }

    public Collection<String> getRootPackageList() {
        return this.scanner.getRootPackages();
    }

    private static String findMethodNameByNoArgs(Class clazz, Collection<Class<? extends Annotation>> methodAnnotations) {
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getReturnType() != Void.TYPE || method.getParameterCount() != 0) continue;
            for (Class<? extends Annotation> aClass : methodAnnotations) {
                if (method.getAnnotationsByType(aClass).length == 0) continue;
                if (method.getParameterCount() != 0) {
                    throw new IllegalStateException("method does not have parameters. class=" + clazz + ",method=" + method);
                }
                return method.getName();
            }
        }
        return null;
    }

    private static PropertyDescriptor[] getPropertyDescriptorsIfCache(Class clazz) throws IllegalStateException {
        PropertyDescriptor[] result = PROPERTY_DESCRIPTOR_CACHE_MAP.get(clazz);
        if (result == null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class, 1);
                PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                result = descriptors != null ? descriptors : EMPTY_DESCRIPTOR_ARRAY;
                PROPERTY_DESCRIPTOR_CACHE_MAP.put(clazz, result);
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("getPropertyDescriptors error. class=" + clazz + e, e);
            }
        }
        return result;
    }

    private static <K, V> ConcurrentMap<K, V> newConcurrentReferenceMap(int initialCapacity) {
        if (CONCURRENT_REFERENCE_MAP_CONSTRUCTOR != null) {
            try {
                return CONCURRENT_REFERENCE_MAP_CONSTRUCTOR.newInstance(initialCapacity);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new ConcurrentHashMap(initialCapacity);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        Method[] result = DECLARED_METHODS_CACHE_MAP.get(clazz);
        if (result == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ApplicationX.findConcreteMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                DECLARED_METHODS_CACHE_MAP.put(clazz, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    private static void eachClass(Class<?> clazz, Consumer<Class> consumer) {
        consumer.accept(clazz);
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            ApplicationX.eachClass(superclass, consumer);
        } else if (clazz.isInterface()) {
            for (Class<?> superIfc : clazz.getInterfaces()) {
                ApplicationX.eachClass(superIfc, consumer);
            }
        }
    }

    private static <T> Constructor<T> getAnyConstructor(Class<?>[] parameterTypes, String ... referenceMaps) {
        for (String s : referenceMaps) {
            try {
                Class<?> aClass = Class.forName(s);
                return aClass.getDeclaredConstructor(parameterTypes);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            }
        }
        return null;
    }

    static /* synthetic */ ConcurrentMap access$1300(int x0) {
        return ApplicationX.newConcurrentReferenceMap(x0);
    }

    public static class BeanWrapper {
        public static final String NESTED_PROPERTY_SEPARATOR = ".";
        public static final char NESTED_PROPERTY_SEPARATOR_CHAR = '.';
        public static final String PROPERTY_KEY_PREFIX = "[";
        public static final char PROPERTY_KEY_PREFIX_CHAR = '[';
        public static final String PROPERTY_KEY_SUFFIX = "]";
        public static final char PROPERTY_KEY_SUFFIX_CHAR = ']';
        private ConversionService conversionService;
        private Object wrappedInstance;
        private Class<?> wrappedClass;
        private PropertyDescriptor[] cachedIntrospectionResults;

        public BeanWrapper(Object wrappedInstance) {
            this.wrappedInstance = wrappedInstance;
            this.wrappedClass = wrappedInstance.getClass();
        }

        public PropertyDescriptor[] getPropertyDescriptors() {
            if (this.cachedIntrospectionResults == null) {
                this.cachedIntrospectionResults = ApplicationX.getPropertyDescriptorsIfCache(this.wrappedClass);
            }
            return this.cachedIntrospectionResults;
        }

        public Class<?> getWrappedClass() {
            return this.wrappedClass;
        }

        public Object getWrappedInstance() {
            return this.wrappedInstance;
        }

        public boolean isReadableProperty(String propertyName) {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (descriptor == null) {
                return false;
            }
            return descriptor.getReadMethod() != null;
        }

        public boolean isWritableProperty(String propertyName) {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (descriptor == null) {
                return false;
            }
            return descriptor.getWriteMethod() != null;
        }

        public Class<?> getPropertyType(String propertyName) throws IllegalArgumentException, IllegalStateException {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (descriptor == null) {
                throw new IllegalArgumentException("No property handler found");
            }
            return descriptor.getPropertyType();
        }

        public Type getPropertyTypeDescriptor(String propertyName) throws IllegalArgumentException, IllegalStateException {
            return this.getPropertyType(propertyName);
        }

        public Object getPropertyValue(String propertyName) throws IllegalArgumentException, IllegalStateException {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (descriptor == null) {
                throw new IllegalArgumentException("No property handler found");
            }
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null) {
                throw new IllegalStateException("Not readable. name=" + propertyName);
            }
            try {
                return readMethod.invoke(this.wrappedInstance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("readMethod error. name=" + propertyName, e);
            }
        }

        public void setPropertyValue(String propertyName, Object value) throws IllegalArgumentException, IllegalStateException {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(propertyName);
            if (descriptor == null) {
                throw new IllegalArgumentException("No property handler found");
            }
            Object convertedResult = this.convertIfNecessary(value, descriptor.getPropertyType());
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) {
                throw new IllegalStateException("Not writable. name=" + propertyName);
            }
            try {
                writeMethod.invoke(this.wrappedInstance, convertedResult);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("writeMethod error. name=" + propertyName, e);
            }
        }

        public void setPropertyValue(PropertyValue pv) throws IllegalArgumentException, IllegalStateException {
            this.setPropertyValue(pv.name, pv.value);
        }

        public void setPropertyValues(Map<?, ?> map) throws IllegalArgumentException, IllegalStateException {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.setPropertyValue(entry.getKey().toString(), entry.getValue());
            }
        }

        public void setPropertyValues(PropertyValues pvs) throws IllegalArgumentException, IllegalStateException {
            this.setPropertyValues(pvs, false, false);
        }

        public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown) throws IllegalArgumentException, IllegalStateException {
            this.setPropertyValues(pvs, ignoreUnknown, false);
        }

        public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown, boolean ignoreInvalid) throws IllegalArgumentException, IllegalStateException {
            for (PropertyValue pv : pvs) {
                try {
                    this.setPropertyValue(pv);
                }
                catch (IllegalArgumentException e) {
                    if (ignoreUnknown) continue;
                    throw e;
                }
                catch (IllegalStateException e) {
                    if (ignoreInvalid) continue;
                    throw e;
                }
            }
        }

        public PropertyDescriptor getPropertyDescriptor(String propertyName) throws IllegalArgumentException {
            for (PropertyDescriptor descriptor : this.getPropertyDescriptors()) {
                if (!descriptor.getName().equals(propertyName)) continue;
                return descriptor;
            }
            return null;
        }

        public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws IllegalArgumentException {
            Class<?> sourceType = value != null ? value.getClass() : null;
            Class<T> targetType = requiredType;
            Object convertValue = value;
            if (this.conversionService.canConvert(sourceType, targetType)) {
                convertValue = this.conversionService.convert(value, targetType);
            }
            return (T)convertValue;
        }
    }

    public static interface Ordered {
        public int getOrder();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
    @Documented
    public static @interface Order {
        public int value() default 0x7FFFFFFF;
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    @Documented
    public static @interface Qualifier {
        public String value() default "";
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Lazy {
        public boolean value() default true;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Scope {
        public String value() default "singleton";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PreDestroy {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PostConstruct {
    }

    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Resource {
        public String name() default "";

        public Class<?> type() default Object.class;
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Primary {
    }

    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Value {
        public String value() default "";
    }

    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Autowired {
        public boolean required() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Component {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Bean {
        public String[] value() default {};
    }

    @Order(value=-2147483628)
    public static class AutowiredConstructorPostProcessor
    implements SmartInstantiationAwareBeanPostProcessor,
    MergedBeanDefinitionPostProcessor {
        private static final Constructor[] EMPTY = new Constructor[0];
        private boolean defaultInjectRequiredField = true;
        private boolean defaultInjectRequiredMethod = true;
        private final ApplicationX applicationX;

        public AutowiredConstructorPostProcessor(ApplicationX applicationX) {
            this.applicationX = Objects.requireNonNull(applicationX);
        }

        @Override
        public void postProcessMergedBeanDefinition(BeanDefinition definition, Class<?> beanType, String beanName) {
            ApplicationX.eachClass(beanType, clazz -> {
                for (Method method : ApplicationX.getDeclaredMethods(clazz)) {
                    Annotation factoryMethodAnnotation = ApplicationX.findDeclaredAnnotation(method, this.applicationX.factoryMethodAnnotations, FACTORY_METHOD_ANNOTATION_CACHE_MAP);
                    if (factoryMethodAnnotation == null) continue;
                    this.addBeanDefinition(method, factoryMethodAnnotation, beanName, beanType);
                }
            });
        }

        @Override
        public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) throws RuntimeException {
            Constructor<?>[] constructors;
            LinkedList list = new LinkedList();
            for (Constructor<?> constructor : constructors = beanClass.getDeclaredConstructors()) {
                if (constructor.isSynthetic()) {
                    return null;
                }
                if (constructor.getParameterCount() != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
                return null;
            }
            for (Constructor<?> constructor : constructors) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                list.add(constructor);
            }
            if (list.isEmpty()) {
                throw new IllegalStateException("No visible constructors in " + beanName);
            }
            return list.size() == constructors.length ? constructors : list.toArray(EMPTY);
        }

        @Override
        public boolean postProcessAfterInstantiation(Object bean, String beanName) throws RuntimeException {
            BeanDefinition definition = this.applicationX.getBeanDefinition(beanName);
            Class<?> beanClass = definition.getBeanClassIfResolve(this.applicationX.getResourceLoader());
            if (ApplicationX.isAbstract(beanClass)) {
                beanClass = bean.getClass();
            }
            this.inject(bean, beanClass);
            return true;
        }

        private void inject(Object bean, Class beanClass) {
            List<InjectElement<Field>> declaredFields = InjectElement.getInjectFields(beanClass, this.applicationX);
            List<InjectElement<Method>> declaredMethods = InjectElement.getInjectMethods(beanClass, this.applicationX);
            for (InjectElement<Field> injectElement : declaredFields) {
                if (((InjectElement)injectElement).required == null) {
                    ((InjectElement)injectElement).required = this.defaultInjectRequiredField;
                }
                injectElement.inject(bean, beanClass);
            }
            for (InjectElement<AccessibleObject> injectElement : declaredMethods) {
                if (((InjectElement)injectElement).required == null) {
                    ((InjectElement)injectElement).required = this.defaultInjectRequiredMethod;
                }
                injectElement.inject(bean, beanClass);
            }
        }

        private void addBeanDefinition(Method method, Annotation factoryMethodAnnotation, String factoryBeanName, Class<?> factoryBeanClass) {
            String[] beanNames = (String[])ApplicationX.getAnnotationValue(factoryMethodAnnotation, "value", String[].class);
            LinkedList<String> beanNameList = new LinkedList<String>(beanNames == null || beanNames.length == 0 ? Arrays.asList(method.getName()) : Arrays.asList(beanNames));
            String beanName = beanNameList.pollFirst();
            BeanDefinition definition = this.applicationX.newBeanDefinition(method.getReturnType(), method);
            InjectElement element = new InjectElement(method, this.applicationX);
            definition.setBeanSupplier(() -> {
                Object bean = element.applicationX.getBean(factoryBeanName);
                return element.inject(bean, factoryBeanClass);
            });
            this.applicationX.addBeanDefinition(beanName, definition);
            for (String alias : beanNameList) {
                this.applicationX.registerAlias(beanName, alias);
            }
        }
    }

    @Order(value=-2147483638)
    public static class RegisteredBeanPostProcessor
    implements BeanPostProcessor {
        private final ApplicationX applicationX;

        public RegisteredBeanPostProcessor(ApplicationX applicationX) {
            this.applicationX = Objects.requireNonNull(applicationX);
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws RuntimeException {
            if (bean instanceof BeanPostProcessor) {
                this.applicationX.addBeanPostProcessor((BeanPostProcessor)bean);
            }
            return bean;
        }
    }

    public static class OrderComparator
    implements Comparator<Object> {
        private final Collection<Class<? extends Annotation>> orderedAnnotations;

        public OrderComparator(Collection<Class<? extends Annotation>> orderedAnnotations) {
            this.orderedAnnotations = Objects.requireNonNull(orderedAnnotations);
        }

        public Collection<Class<? extends Annotation>> getOrderedAnnotations() {
            return this.orderedAnnotations;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int c2;
            int c1 = this.convertInt(o1);
            return c1 < (c2 = this.convertInt(o2)) ? -1 : 1;
        }

        protected int convertInt(Object o) {
            Number value;
            Annotation annotation;
            int order = o == null ? Integer.MAX_VALUE : (o instanceof Ordered ? ((Ordered)o).getOrder() : ((annotation = ApplicationX.findAnnotation(o.getClass(), this.orderedAnnotations)) != null ? ((value = (Number)ApplicationX.getAnnotationValue(annotation, "value", Number.class)) != null ? value.intValue() : Integer.MAX_VALUE) : Integer.MAX_VALUE));
            return order;
        }
    }

    public static class PropertyValue {
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
        private Object source;
        private final String name;
        private final Object value;
        private boolean optional = false;
        private boolean converted = false;
        private Object convertedValue;

        public PropertyValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class PropertyValues
    implements Iterable<PropertyValue> {
        public static PropertyValues EMPTY = new PropertyValues(new PropertyValue[0]);
        private PropertyValue[] propertyValues;

        public PropertyValues(PropertyValue[] propertyValues) {
            this.propertyValues = propertyValues;
        }

        @Override
        public Iterator<PropertyValue> iterator() {
            return Arrays.asList(this.getPropertyValues()).iterator();
        }

        @Override
        public Spliterator<PropertyValue> spliterator() {
            return Spliterators.spliterator(this.getPropertyValues(), 0);
        }

        public Stream<PropertyValue> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public PropertyValue[] getPropertyValues() {
            return this.propertyValues;
        }

        public boolean contains(String propertyName) {
            for (PropertyValue value : this.propertyValues) {
                if (!Objects.equals(propertyName, value.name)) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.propertyValues.length == 0;
        }
    }

    public static interface PropertyEditor {
        public void setValue(Object var1);

        public Object getValue();
    }

    public static interface ConversionService {
        default public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
            return true;
        }

        default public <T> T convert(Object source, Class<T> targetType) {
            return (T)source;
        }
    }

    public static interface InstantiationAwareBeanPostProcessor
    extends BeanPostProcessor {
        default public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws RuntimeException {
            return null;
        }

        default public boolean postProcessAfterInstantiation(Object bean, String beanName) throws RuntimeException {
            return true;
        }

        default public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws RuntimeException {
            return pvs;
        }

        default public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws RuntimeException {
            return pvs;
        }
    }

    public static interface SmartInstantiationAwareBeanPostProcessor
    extends InstantiationAwareBeanPostProcessor {
        default public Class<?> predictBeanType(Class<?> beanClass, String beanName) throws RuntimeException {
            return null;
        }

        default public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) throws RuntimeException {
            return null;
        }
    }

    public static interface MergedBeanDefinitionPostProcessor
    extends BeanPostProcessor {
        default public void postProcessMergedBeanDefinition(BeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        }

        default public void resetBeanDefinition(String beanName) {
        }
    }

    public static interface BeanPostProcessor {
        default public Object postProcessBeforeInitialization(Object bean, String beanName) throws RuntimeException {
            return bean;
        }

        default public Object postProcessAfterInitialization(Object bean, String beanName) throws RuntimeException {
            return bean;
        }
    }

    public static interface DisposableBean {
        public void destroy() throws Exception;
    }

    public static interface InitializingBean {
        public void afterPropertiesSet() throws Exception;
    }

    public static interface ApplicationAware
    extends Aware {
        public void setApplication(ApplicationX var1);
    }

    public static interface BeanNameAware
    extends Aware {
        public void setBeanName(String var1);
    }

    public static interface Aware {
    }

    public static interface AbstractBeanFactory {
        public Object createBean(String var1, BeanDefinition var2, Object[] var3) throws RuntimeException;
    }

    public static class ValueHolder {
        private Object value;
        private String type;
        private String name;
        private Object source;
        private boolean converted = false;
        private Object convertedValue;

        public ValueHolder(Object value) {
            this.value = value;
        }
    }

    public static class BeanDefinition {
        public static final String SCOPE_SINGLETON = "singleton";
        public static final String SCOPE_PROTOTYPE = "prototype";
        public static final int AUTOWIRE_NO = 0;
        public static final int AUTOWIRE_BY_NAME = 1;
        public static final int AUTOWIRE_BY_TYPE = 2;
        public static final int AUTOWIRE_CONSTRUCTOR = 3;
        public static final int DEPENDENCY_CHECK_NONE = 0;
        public static final int DEPENDENCY_CHECK_OBJECTS = 1;
        public static final int DEPENDENCY_CHECK_SIMPLE = 2;
        public static final int DEPENDENCY_CHECK_ALL = 3;
        final Object postProcessingLock = new Object();
        private boolean postProcessed = false;
        private int dependencyCheck = 0;
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
        private Supplier<?> beanSupplier;
        private Object beanClass;
        private String beanClassName;
        private String scope = "singleton";
        private boolean primary = false;
        private boolean lazyInit = false;
        private String initMethodName;
        private String destroyMethodName;
        private int autowireMode = 0;
        private PropertyValues propertyValues = PropertyValues.EMPTY;
        private boolean allowCaching = true;
        private volatile Boolean beforeInstantiationResolved;
        private final Map<Integer, ValueHolder> constructorArgumentValues = new LinkedHashMap<Integer, ValueHolder>();

        public Map<Integer, ValueHolder> getConstructorArgumentValues() {
            return this.constructorArgumentValues;
        }

        public String getDestroyMethodName() {
            return this.destroyMethodName;
        }

        public void setDestroyMethodName(String destroyMethodName) {
            this.destroyMethodName = destroyMethodName;
        }

        public int getDependencyCheck() {
            return this.dependencyCheck;
        }

        public void setDependencyCheck(int dependencyCheck) {
            this.dependencyCheck = dependencyCheck;
        }

        public String getInitMethodName() {
            return this.initMethodName;
        }

        public void setInitMethodName(String initMethodName) {
            this.initMethodName = initMethodName;
        }

        public boolean isSingleton() {
            return SCOPE_SINGLETON.equals(this.scope);
        }

        public boolean isPrototype() {
            return SCOPE_PROTOTYPE.equals(this.scope);
        }

        public boolean isLazyInit() {
            return this.lazyInit;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public String getScope() {
            return this.scope;
        }

        public void setPropertyValues(PropertyValues propertyValues) {
            this.propertyValues = propertyValues;
        }

        public PropertyValues getPropertyValues() {
            return this.propertyValues;
        }

        public void setBeforeInstantiationResolved(Boolean beforeInstantiationResolved) {
            this.beforeInstantiationResolved = beforeInstantiationResolved;
        }

        public Boolean getBeforeInstantiationResolved() {
            return this.beforeInstantiationResolved;
        }

        public Class getBeanClass() {
            if (this.beanClass == null) {
                throw new IllegalStateException("No bean class specified on bean definition");
            }
            if (!(this.beanClass instanceof Class)) {
                throw new IllegalStateException("Bean class name [" + this.beanClass + "] has not been resolved into an actual Class");
            }
            return (Class)this.beanClass;
        }

        public Class getBeanClassIfResolve(Supplier<ClassLoader> loaderSupplier) {
            if (this.beanClass == null || !(this.beanClass instanceof Class)) {
                this.beanClass = this.resolveBeanClass(loaderSupplier.get());
            }
            return (Class)this.beanClass;
        }

        public Class resolveBeanClass(ClassLoader classLoader) {
            try {
                return Class.forName(this.beanClassName, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("getBeanClass error." + e, e);
            }
        }

        public Supplier<?> getBeanSupplier() {
            return this.beanSupplier;
        }

        public void setAttribute(String name, Object value) {
            this.attributes.put(name, value);
        }

        public Object removeAttribute(String name) {
            return this.attributes.remove(name);
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void setBeanSupplier(Supplier<?> beanSupplier) {
            this.beanSupplier = beanSupplier;
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public void setLazyInit(boolean lazyInit) {
            this.lazyInit = lazyInit;
        }

        public String getBeanClassName() {
            return this.beanClassName;
        }

        public void setBeanClassName(String beanClassName) {
            this.beanClassName = beanClassName;
        }

        public int getAutowireMode() {
            return this.autowireMode;
        }

        public void setAutowireMode(int autowireMode) {
            this.autowireMode = autowireMode;
        }

        public String toString() {
            return this.scope + '{' + this.beanClassName + '}';
        }
    }

    private class DefaultBeanFactory
    implements AbstractBeanFactory {
        private final Map<Class<?>, PropertyDescriptor[]> filteredPropertyDescriptorsCache = new ConcurrentHashMap();
        private boolean defaultInjectRequiredConstructor = true;
        private boolean allowCircularReferences = true;

        private DefaultBeanFactory() {
        }

        @Override
        public Object createBean(String beanName, BeanDefinition definition, Object[] args) {
            Object bean = this.resolveBeforeInstantiation(beanName, definition);
            if (bean != null) {
                return bean;
            }
            return this.doCreateBean(beanName, definition, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doCreateBean(String beanName, BeanDefinition definition, Object[] args) {
            boolean earlySingletonExposure;
            BeanWrapper beanInstanceWrapper = this.createBeanInstance(beanName, definition, args);
            Object exposedObject = beanInstanceWrapper.getWrappedInstance();
            if (!ApplicationX.this.isLifecycle(beanName)) {
                return exposedObject;
            }
            Class<?> beanType = beanInstanceWrapper.getWrappedClass();
            Object object = definition.postProcessingLock;
            synchronized (object) {
                if (!definition.postProcessed) {
                    try {
                        this.applyMergedBeanDefinitionPostProcessors(definition, beanType, beanName);
                    }
                    catch (Throwable ex) {
                        throw new IllegalStateException("Post-processing of merged bean definition failed. beanName=" + beanName, ex);
                    }
                    definition.postProcessed = true;
                }
            }
            boolean bl = earlySingletonExposure = definition.isSingleton() && this.allowCircularReferences && ApplicationX.this.isSingletonCurrentlyInCreation(beanName);
            if (earlySingletonExposure) {
                ApplicationX.this.addSingleton(beanName, exposedObject);
            }
            this.populateBean(beanName, definition, beanInstanceWrapper);
            exposedObject = ApplicationX.this.initializeBean(beanName, beanInstanceWrapper, definition);
            return exposedObject;
        }

        protected void applyMergedBeanDefinitionPostProcessors(BeanDefinition mbd, Class<?> beanType, String beanName) {
            for (BeanPostProcessor bp : new ArrayList(ApplicationX.this.beanPostProcessors)) {
                if (!(bp instanceof MergedBeanDefinitionPostProcessor)) continue;
                MergedBeanDefinitionPostProcessor bdp = (MergedBeanDefinitionPostProcessor)bp;
                bdp.postProcessMergedBeanDefinition(mbd, beanType, beanName);
            }
        }

        protected Object resolveBeforeInstantiation(String beanName, BeanDefinition mbd) {
            Class targetType;
            Object bean = null;
            if (!Boolean.FALSE.equals(mbd.beforeInstantiationResolved) && (targetType = this.resolveBeanClass(beanName, mbd, ApplicationX.this.resourceLoader)) != null && (bean = this.applyBeanPostProcessorsBeforeInstantiation(targetType, beanName)) != null) {
                bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
            }
            return bean;
        }

        protected Object applyBeanPostProcessorsBeforeInstantiation(Class<?> beanClass, String beanName) {
            for (BeanPostProcessor bp : new ArrayList(ApplicationX.this.beanPostProcessors)) {
                InstantiationAwareBeanPostProcessor ibp;
                Object result;
                if (!(bp instanceof InstantiationAwareBeanPostProcessor) || (result = (ibp = (InstantiationAwareBeanPostProcessor)bp).postProcessBeforeInstantiation(beanClass, beanName)) == null) continue;
                return result;
            }
            return null;
        }

        protected Class resolveBeanClass(String beanName, BeanDefinition definition, Supplier<ClassLoader> loaderSupplier) {
            return definition.getBeanClassIfResolve(loaderSupplier);
        }

        protected BeanWrapper createBeanInstance(String beanName, BeanDefinition definition, Object[] args) {
            Object beanInstance;
            Supplier<?> beanSupplier = definition.getBeanSupplier();
            if (beanSupplier != null) {
                beanInstance = beanSupplier.get();
            } else {
                Class beanClass = this.resolveBeanClass(beanName, definition, ApplicationX.this.resourceLoader);
                Constructor<?>[] ctors = this.determineConstructorsFromBeanPostProcessors(beanClass, beanName);
                if (ctors != null || definition.getAutowireMode() == 3 || definition.getConstructorArgumentValues().size() > 0 || args != null && args.length > 0) {
                    return this.autowireConstructor(beanName, definition, ctors, args);
                }
                beanInstance = this.newInstance(beanClass);
            }
            BeanWrapper bw = new BeanWrapper(beanInstance);
            this.initBeanWrapper(bw);
            return bw;
        }

        protected BeanWrapper autowireConstructor(String beanName, BeanDefinition mbd, Constructor<?>[] ctors, Object[] explicitArgs) throws IllegalStateException {
            int errorCount = 0;
            for (Constructor<?> constructor : ctors) {
                InjectElement element = new InjectElement(constructor, ApplicationX.this);
                try {
                    Object beanInstance;
                    if (element.required == null) {
                        element.required = this.defaultInjectRequiredConstructor;
                    }
                    if ((beanInstance = element.newInstance(explicitArgs)) == null) continue;
                    BeanWrapper bw = new BeanWrapper(beanInstance);
                    this.initBeanWrapper(bw);
                    return bw;
                }
                catch (IllegalStateException e) {
                    ++errorCount;
                }
            }
            throw new IllegalStateException("can not create instances. " + Arrays.toString(ctors) + ". " + ApplicationX.this.singletonsCurrentlyInCreation);
        }

        protected Constructor<?>[] determineConstructorsFromBeanPostProcessors(Class<?> beanClass, String beanName) throws RuntimeException {
            for (BeanPostProcessor bp : new ArrayList(ApplicationX.this.beanPostProcessors)) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                Constructor<?>[] ctors;
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor) || (ctors = (ibp = (SmartInstantiationAwareBeanPostProcessor)bp).determineCandidateConstructors(beanClass, beanName)) == null) continue;
                return ctors;
            }
            return null;
        }

        protected void initBeanWrapper(BeanWrapper bw) {
            bw.conversionService = new ConversionService(){};
        }

        protected void populateBean(String beanName, BeanDefinition definition, BeanWrapper bw) {
            boolean continueWithPropertyPopulation = true;
            for (BeanPostProcessor bp : new ArrayList(ApplicationX.this.beanPostProcessors)) {
                InstantiationAwareBeanPostProcessor ibp;
                if (!(bp instanceof InstantiationAwareBeanPostProcessor) || (ibp = (InstantiationAwareBeanPostProcessor)bp).postProcessAfterInstantiation(bw.getWrappedInstance(), beanName)) continue;
                continueWithPropertyPopulation = false;
                break;
            }
            if (!continueWithPropertyPopulation) {
                return;
            }
            PropertyValues pvs = definition.getPropertyValues();
            if (definition.getAutowireMode() == 1 || definition.getAutowireMode() == 2) {
                PropertyValues newPvs = new PropertyValues(pvs.getPropertyValues());
                if (definition.getAutowireMode() == 1) {
                    this.autowireByName(beanName, definition, bw, newPvs);
                }
                if (definition.getAutowireMode() == 2) {
                    this.autowireByType(beanName, definition, bw, newPvs);
                }
                pvs = newPvs;
            }
            boolean needsDepCheck = definition.getDependencyCheck() != 0;
            PropertyDescriptor[] filteredPds = null;
            for (BeanPostProcessor bp : new ArrayList(ApplicationX.this.beanPostProcessors)) {
                if (!(bp instanceof InstantiationAwareBeanPostProcessor)) continue;
                InstantiationAwareBeanPostProcessor ibp = (InstantiationAwareBeanPostProcessor)bp;
                PropertyValues pvsToUse = ibp.postProcessProperties(pvs, bw.getWrappedInstance(), beanName);
                if (pvsToUse == null) {
                    if (filteredPds == null) {
                        filteredPds = this.filterPropertyDescriptorsForDependencyCheck(bw, definition.allowCaching);
                    }
                    if ((pvsToUse = ibp.postProcessPropertyValues(pvs, filteredPds, bw.getWrappedInstance(), beanName)) == null) {
                        return;
                    }
                }
                pvs = pvsToUse;
            }
            if (needsDepCheck) {
                if (filteredPds == null) {
                    filteredPds = this.filterPropertyDescriptorsForDependencyCheck(bw, definition.allowCaching);
                }
                this.checkDependencies(beanName, definition, filteredPds, pvs);
            }
            if (pvs != null) {
                this.applyPropertyValues(beanName, definition, bw, pvs);
            }
        }

        protected void checkDependencies(String beanName, BeanDefinition mbd, PropertyDescriptor[] pds, PropertyValues pvs) throws IllegalStateException {
            int dependencyCheck = mbd.getDependencyCheck();
            for (PropertyDescriptor pd : pds) {
                boolean unsatisfied;
                if (pd.getWriteMethod() == null || pvs != null && pvs.contains(pd.getName())) continue;
                boolean isSimple = ApplicationX.isSimpleProperty(pd.getPropertyType());
                boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
                if (!unsatisfied) continue;
                throw new IllegalStateException("Set this property value or disable dependency checking for this bean.");
            }
        }

        protected PropertyDescriptor[] filterPropertyDescriptorsForDependencyCheck(BeanWrapper bw, boolean cache) {
            PropertyDescriptor[] filtered = this.filteredPropertyDescriptorsCache.get(bw.getWrappedClass());
            if (filtered == null) {
                PropertyDescriptor[] existing;
                filtered = bw.getPropertyDescriptors();
                if (cache && (existing = this.filteredPropertyDescriptorsCache.putIfAbsent(bw.getWrappedClass(), filtered)) != null) {
                    filtered = existing;
                }
            }
            return filtered;
        }

        public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) throws RuntimeException {
            Object result = existingBean;
            for (BeanPostProcessor processor : new ArrayList(ApplicationX.this.beanPostProcessors)) {
                Object current = processor.postProcessAfterInitialization(result, beanName);
                if (current == null) {
                    return result;
                }
                result = current;
            }
            return result;
        }

        protected void applyPropertyValues(String beanName, BeanDefinition definition, BeanWrapper bw, PropertyValues pvs) {
            bw.setPropertyValues(pvs);
        }

        private <T> T newInstance(Class<T> clazz) throws IllegalStateException {
            try {
                T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return instance;
            }
            catch (Exception e) {
                throw new IllegalStateException("newInstanceByJdk error=" + e, e);
            }
        }

        private void autowireByType(String beanName, BeanDefinition definition, BeanWrapper beanInstanceWrapper, PropertyValues pvs) {
        }

        private void autowireByName(String beanName, BeanDefinition definition, BeanWrapper beanInstanceWrapper, PropertyValues pvs) {
        }
    }

    private static class DefaultBeanNameGenerator
    implements Function<BeanDefinition, String> {
        private final Map<Class, Boolean> scannerAnnotationCacheMap = ApplicationX.access$1300(32);
        private final ApplicationX applicationX;

        public DefaultBeanNameGenerator(ApplicationX applicationX) {
            this.applicationX = Objects.requireNonNull(applicationX);
        }

        @Override
        public String apply(BeanDefinition definition) {
            Class beanClass = definition.getBeanClassIfResolve(this.applicationX.resourceLoader);
            Annotation annotation = ApplicationX.findDeclaredAnnotation(beanClass, this.applicationX.scannerAnnotations, this.scannerAnnotationCacheMap);
            String beanName = null;
            if (annotation != null) {
                beanName = (String)ApplicationX.getAnnotationValue(annotation, "value", String.class);
            }
            if (beanName == null || beanName.isEmpty()) {
                String className = beanClass.getName();
                int lastDotIndex = className.lastIndexOf(46);
                int nameEndIndex = className.indexOf("$$");
                if (nameEndIndex == -1) {
                    nameEndIndex = className.length();
                }
                String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
                shortName = shortName.replace('$', '.');
                beanName = Introspector.decapitalize(shortName);
            }
            return beanName;
        }
    }

    public static class InjectElement<T extends Member> {
        private static final String[] QUALIFIER_FIELDS = new String[]{"value", "name"};
        private final T member;
        private final ApplicationX applicationX;
        private final Annotation autowiredAnnotation;
        private final int[] autowireType;
        private final Boolean[] requireds;
        private Type[] requiredType;
        private Class[] requiredClass;
        private String[] requiredName;
        private Boolean required;

        public InjectElement(Executable executable, ApplicationX applicationX) {
            int parameterCount = executable.getParameterCount();
            this.member = executable;
            this.applicationX = applicationX;
            this.autowiredAnnotation = ApplicationX.findDeclaredAnnotation(executable, applicationX.autowiredAnnotations, AUTOWIRED_ANNOTATION_CACHE_MAP);
            this.autowireType = new int[parameterCount];
            this.requiredClass = new Class[parameterCount];
            this.requiredType = new Type[parameterCount];
            this.requiredName = new String[parameterCount];
            this.requireds = new Boolean[parameterCount];
            Parameter[] parameters = executable.getParameters();
            for (int i = 0; i < parameterCount; ++i) {
                Parameter parameter = parameters[i];
                this.requiredClass[i] = parameter.getType();
                this.autowireType[i] = applicationX.findAutowireType(parameter);
                switch (this.autowireType[i]) {
                    case 2: {
                        Annotation parameterInjectAnnotation = ApplicationX.findDeclaredAnnotation(parameter, applicationX.autowiredAnnotations, AUTOWIRED_ANNOTATION_CACHE_MAP);
                        this.requiredType[i] = InjectElement.findAnnotationDeclaredType(parameterInjectAnnotation, parameter.getParameterizedType());
                        break;
                    }
                    case 1: {
                        String autowiredBeanName;
                        Annotation qualifierAnnotation = ApplicationX.findDeclaredAnnotation(parameter, applicationX.qualifierAnnotations, QUALIFIER_ANNOTATION_CACHE_MAP);
                        this.requiredName[i] = autowiredBeanName = qualifierAnnotation != null ? InjectElement.getQualifierAnnotationValue(qualifierAnnotation) : parameter.getName();
                        break;
                    }
                }
                Annotation parameterAutowiredAnnotation = ApplicationX.findDeclaredAnnotation(parameter, applicationX.autowiredAnnotations, AUTOWIRED_ANNOTATION_CACHE_MAP);
                this.requireds[i] = parameterAutowiredAnnotation != null ? (Boolean)ApplicationX.getAnnotationValue(parameterAutowiredAnnotation, "required", Boolean.class) : null;
            }
            if (this.autowiredAnnotation != null) {
                this.required = (Boolean)ApplicationX.getAnnotationValue(this.autowiredAnnotation, "required", Boolean.class);
            }
        }

        public InjectElement(Field field, ApplicationX applicationX) {
            this.member = field;
            this.applicationX = applicationX;
            this.autowiredAnnotation = ApplicationX.findDeclaredAnnotation(field, applicationX.autowiredAnnotations, AUTOWIRED_ANNOTATION_CACHE_MAP);
            this.autowireType = new int[]{applicationX.findAutowireType(field)};
            this.requiredClass = new Class[]{field.getType()};
            switch (this.autowireType[0]) {
                case 2: {
                    this.requiredType = new Type[]{InjectElement.findAnnotationDeclaredType(this.autowiredAnnotation, field.getGenericType())};
                    break;
                }
                case 1: {
                    Annotation qualifierAnnotation = ApplicationX.findDeclaredAnnotation(field, applicationX.qualifierAnnotations, QUALIFIER_ANNOTATION_CACHE_MAP);
                    String autowiredBeanName = qualifierAnnotation != null ? InjectElement.getQualifierAnnotationValue(qualifierAnnotation) : field.getName();
                    this.requiredName = new String[]{autowiredBeanName};
                    break;
                }
            }
            if (this.autowiredAnnotation != null) {
                this.required = (Boolean)ApplicationX.getAnnotationValue(this.autowiredAnnotation, "required", Boolean.class);
            }
            this.requireds = new Boolean[]{this.required};
        }

        private static String getQualifierAnnotationValue(Annotation qualifierAnnotation) {
            return (String)ApplicationX.getAnnotationValue(qualifierAnnotation, InjectElement.QUALIFIER_FIELDS, String.class);
        }

        public static List<InjectElement<Field>> getInjectFields(Class rootClass, ApplicationX applicationX) {
            ArrayList<InjectElement<Field>> list = new ArrayList<InjectElement<Field>>();
            for (Class clazz = rootClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (null == ApplicationX.findDeclaredAnnotation(field, applicationX.autowiredAnnotations, AUTOWIRED_ANNOTATION_CACHE_MAP)) continue;
                    InjectElement element = new InjectElement(field, applicationX);
                    list.add(element);
                }
            }
            return list;
        }

        public static List<InjectElement<Method>> getInjectMethods(Class rootClass, ApplicationX applicationX) {
            ArrayList<InjectElement<Method>> result = new ArrayList<InjectElement<Method>>();
            ApplicationX.eachClass(rootClass, clazz -> {
                for (Method method : ApplicationX.getDeclaredMethods(clazz)) {
                    if (null == ApplicationX.findDeclaredAnnotation(method, applicationX.autowiredAnnotations, AUTOWIRED_ANNOTATION_CACHE_MAP)) continue;
                    result.add(new InjectElement(method, applicationX));
                }
            });
            return result;
        }

        private Object[] getInjectValues(Class targetClass) throws IllegalStateException {
            Boolean defaultRequired = this.required;
            if (defaultRequired == null) {
                defaultRequired = Boolean.FALSE;
            }
            Object[] values = new Object[this.autowireType.length];
            for (int i = 0; i < this.autowireType.length; ++i) {
                Object injectResource;
                Object desc;
                Boolean required = this.requireds[i];
                if (required == null) {
                    required = defaultRequired;
                }
                switch (this.autowireType[i]) {
                    case 1: {
                        desc = this.requiredName[i];
                        injectResource = this.applicationX.getBean(this.requiredName[i], null, false);
                        break;
                    }
                    default: {
                        Class autowireClass = this.requiredType[i] instanceof Class ? (Class)this.requiredType[i] : InjectElement.findConcreteClass(this.requiredClass[i], targetClass);
                        desc = autowireClass;
                        if (autowireClass == Object.class) {
                            injectResource = null;
                            break;
                        }
                        if (ApplicationX.isAbstract(autowireClass)) {
                            List implList = this.applicationX.getBeanForType(autowireClass);
                            injectResource = implList.isEmpty() ? null : implList.get(0);
                            break;
                        }
                        injectResource = this.applicationX.getBean(autowireClass, null, false);
                        break;
                    }
                }
                if (injectResource == null && required.booleanValue()) {
                    throw new IllegalStateException("Required part[" + (i + 1) + "] '" + desc + "' is not present. member='" + this.member + "',class=" + this.member.getDeclaringClass() + ". Dependency annotations: Autowired(required=false)");
                }
                values[i] = injectResource;
            }
            return values;
        }

        private static Class findConcreteClass(Class<?> parameterGenericClass, Class concreteChildClass) {
            BiFunction<Type, Class, Class> findFunction = (generic, genericSuper) -> {
                if (generic instanceof ParameterizedType) {
                    for (Type actualTypeArgument : ((ParameterizedType)generic).getActualTypeArguments()) {
                        if (!(actualTypeArgument instanceof Class) || !genericSuper.isAssignableFrom((Class)actualTypeArgument)) continue;
                        return (Class)actualTypeArgument;
                    }
                }
                return null;
            };
            Class result = findFunction.apply(concreteChildClass.getGenericSuperclass(), parameterGenericClass);
            if (result == null) {
                Type genericInterface;
                Type[] typeArray = concreteChildClass.getGenericInterfaces();
                int n = typeArray.length;
                for (int i = 0; i < n && null == (result = findFunction.apply(genericInterface = typeArray[i], parameterGenericClass)); ++i) {
                }
            }
            return result == null ? parameterGenericClass : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inject(Object target, Class targetClass) throws IllegalStateException {
            block15: {
                if (targetClass == null) {
                    targetClass = target.getClass();
                }
                if (this.member instanceof Field) {
                    Field field = (Field)this.member;
                    if (Modifier.isFinal(field.getModifiers())) {
                        return null;
                    }
                    Object[] values = this.getInjectValues(targetClass);
                    try {
                        boolean accessible = field.isAccessible();
                        try {
                            field.setAccessible(true);
                            field.set(target, values[0]);
                            break block15;
                        }
                        finally {
                            field.setAccessible(accessible);
                        }
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("inject error=" + e + ". class=" + target.getClass() + ",field=" + this.member);
                    }
                }
                if (this.member instanceof Method) {
                    Method method = (Method)this.member;
                    Object[] values = this.getInjectValues(targetClass);
                    boolean accessible = method.isAccessible();
                    try {
                        method.setAccessible(true);
                        Object object = method.invoke(target, values);
                        method.setAccessible(accessible);
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            method.setAccessible(accessible);
                            throw throwable;
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException("inject error=" + e + ". class=" + target.getClass() + ",method=" + this.member);
                        }
                    }
                }
                if (this.member instanceof Constructor) {
                    return this.newInstance(null);
                }
            }
            return null;
        }

        public Object newInstance(Object[] args) throws IllegalStateException {
            if (this.member.getDeclaringClass().isEnum()) {
                return null;
            }
            if (!(this.member instanceof Constructor)) {
                throw new IllegalStateException("member not instanceof Constructor!");
            }
            Constructor constructor = (Constructor)this.member;
            if (args == null || args.length == 0) {
                args = this.getInjectValues(this.member.getDeclaringClass());
            }
            boolean accessible = constructor.isAccessible();
            try {
                Object instance;
                constructor.setAccessible(true);
                Object t = instance = constructor.newInstance(args);
                return t;
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("inject error=" + e + ". method=" + this.member, e);
            }
            finally {
                constructor.setAccessible(accessible);
            }
        }

        private static Type findAnnotationDeclaredType(Annotation annotation, Type def) {
            if (annotation == null) {
                return def;
            }
            Type annotationDeclaredType = (Type)ApplicationX.getAnnotationValue(annotation, "type", Type.class);
            if (annotationDeclaredType != null && annotationDeclaredType != Object.class) {
                return annotationDeclaredType;
            }
            return def;
        }
    }

    public static class Scanner {
        private final Collection<String> rootPackages = new ArrayList<String>(6);
        private final Collection<String> excludes = new LinkedHashSet<String>(6);

        public Collection<String> getRootPackages() {
            return this.rootPackages;
        }

        public Collection<String> getExcludes() {
            return this.excludes;
        }

        public void doScan(String basePackage, String currentPackage, URL url, BiConsumer<URL, String> classConsumer) throws IOException {
            StringBuilder buffer = new StringBuilder();
            String splashPath = this.dotToSplash(basePackage);
            if (url == null || this.existContains(url)) {
                return;
            }
            String filePath = this.getRootPath(URLDecoder.decode(url.getFile(), "UTF-8"));
            List<String> names = this.isJarFile(filePath) ? this.readFromJarFile(filePath, splashPath) : this.readFromDirectory(filePath);
            for (String name : names) {
                if (this.isClassFile(name)) {
                    String className = this.toClassName(buffer, name, currentPackage);
                    classConsumer.accept(url, className);
                    continue;
                }
                String nextPackage = currentPackage == null || currentPackage.isEmpty() ? name : currentPackage + "." + name;
                this.doScan(basePackage, nextPackage, new URL(url + "/" + name), classConsumer);
            }
        }

        public void doScan(String basePackage, ClassLoader loader, BiConsumer<URL, String> classConsumer) throws IOException {
            StringBuilder buffer = new StringBuilder();
            String splashPath = this.dotToSplash(basePackage);
            URL url = loader.getResource(splashPath);
            if (url == null || this.existContains(url)) {
                return;
            }
            String filePath = this.getRootPath(url.getFile());
            List<String> names = this.isJarFile(filePath) ? this.readFromJarFile(filePath, splashPath) : this.readFromDirectory(filePath);
            for (String name : names) {
                if (this.isClassFile(name)) {
                    String className = this.toClassName(buffer, name, basePackage);
                    classConsumer.accept(url, className);
                    continue;
                }
                this.doScan(basePackage + "." + name, loader, classConsumer);
            }
        }

        private boolean existContains(URL url) {
            if (this.excludes.isEmpty()) {
                return false;
            }
            String[] urlStr = url.getPath().split("/");
            for (String s : this.excludes) {
                for (String u : urlStr) {
                    if (!u.equals(s)) continue;
                    return true;
                }
            }
            return false;
        }

        private String toClassName(StringBuilder buffer, String shortName, String basePackage) {
            buffer.setLength(0);
            shortName = this.trimExtension(shortName);
            if (shortName.contains(basePackage)) {
                buffer.append(shortName);
            } else {
                buffer.append(basePackage).append('.').append(shortName);
            }
            return buffer.toString();
        }

        private List<String> readFromJarFile(String jarPath, String splashedPackageName) throws IOException {
            JarInputStream jarIn = new JarInputStream(new FileInputStream(jarPath));
            JarEntry entry = jarIn.getNextJarEntry();
            ArrayList<String> nameList = new ArrayList<String>();
            while (null != entry) {
                String name = entry.getName();
                if (!entry.isDirectory() && name.startsWith(splashedPackageName) && this.isClassFile(name)) {
                    nameList.add(name);
                }
                entry = jarIn.getNextJarEntry();
            }
            return nameList;
        }

        private List<String> readFromDirectory(String path) {
            File file = new File(path);
            String[] names = file.list();
            if (null == names) {
                return Collections.emptyList();
            }
            return Arrays.asList(names);
        }

        private boolean isClassFile(String name) {
            return name.endsWith(".class");
        }

        private boolean isJarFile(String name) {
            return name.endsWith(".jar");
        }

        private String getRootPath(String fileUrl) {
            int pos = fileUrl.indexOf(33);
            if (-1 == pos) {
                return fileUrl;
            }
            return fileUrl.substring(5, pos);
        }

        private String dotToSplash(String name) {
            return name.replaceAll("\\.", "/");
        }

        private String trimExtension(String name) {
            int pos = name.indexOf(46);
            if (-1 != pos) {
                name = name.substring(0, pos);
            }
            return name.replace("/", ".");
        }

        private String trimURI(String uri) {
            String trimmed = uri.substring(1);
            int splashIndex = trimmed.indexOf(47);
            return trimmed.substring(splashIndex);
        }

        public String toString() {
            return "Scanner{rootPackages=" + this.rootPackages + ", excludes=" + this.excludes + '}';
        }
    }

    public class ScannerResult {
        public long scannerBeginTimestamp;
        public long scannerEndTimestamp;
        public long injectBeginTimestamp;
        public long injectEndTimestamp;
        private final AtomicInteger classCount = new AtomicInteger();
        private final Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
        private final Set<URL> tempUrls = new LinkedHashSet<URL>();
        private final Set<URL> classUrls = new LinkedHashSet<URL>();
        private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(64);
        private final Map<Class, Boolean> scannerAnnotationCacheMap = new ConcurrentHashMap<Class, Boolean>(64);

        public AtomicInteger getClassCount() {
            return this.classCount;
        }

        public Set<ClassLoader> getClassLoaders() {
            return this.classLoaders;
        }

        public Set<URL> getClassUrls() {
            return this.classUrls;
        }

        public Map<String, BeanDefinition> getBeanDefinitionMap() {
            return this.beanDefinitionMap;
        }

        public Map<Class, Boolean> getScannerAnnotationCacheMap() {
            return this.scannerAnnotationCacheMap;
        }

        public void addClassUrl(ClassLoader loader, URL url) {
            BiPredicate<ClassLoader, URL> filter = ApplicationX.this.getResourceLoaderUrlFilter();
            if (filter.test(loader, url)) {
                this.classLoaders.add(loader);
                this.classUrls.add(url);
                this.tempUrls.add(url);
            }
        }

        public int inject() {
            return this.inject(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int inject(boolean lazy) {
            this.injectBeginTimestamp = System.currentTimeMillis();
            try {
                LinkedList<String> beanNameList = new LinkedList<String>();
                for (Map.Entry<String, BeanDefinition> entry : this.beanDefinitionMap.entrySet()) {
                    String beanName = entry.getKey();
                    BeanDefinition definition = entry.getValue();
                    ApplicationX.this.addBeanDefinition(beanName, definition);
                    if (!definition.isSingleton() || definition.isLazyInit()) continue;
                    if (BeanPostProcessor.class.isAssignableFrom(definition.getBeanClass())) {
                        beanNameList.addFirst(beanName);
                        continue;
                    }
                    beanNameList.addLast(beanName);
                }
                if (!lazy) {
                    for (String beanName : beanNameList) {
                        ApplicationX.this.getBean(beanName, null, true);
                    }
                }
                this.beanDefinitionMap.clear();
                this.scannerAnnotationCacheMap.clear();
                int n = beanNameList.size();
                return n;
            }
            finally {
                this.injectEndTimestamp = System.currentTimeMillis();
            }
        }
    }
}

