/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core.util;

import com.github.netty.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;

public class AnnotationMethodToMethodNameFunction
implements Function<Method, String> {
    private final Collection<Class<? extends Annotation>> methodNameAnnotationClasses;
    private final Collection<String> fieldNameList = new LinkedHashSet<String>(Arrays.asList("value", "name"));
    private final Map<Integer, Boolean> existAnnotationMap = new WeakHashMap<Integer, Boolean>(128);

    public AnnotationMethodToMethodNameFunction(Collection<Class<? extends Annotation>> methodNameAnnotationClasses) {
        this.methodNameAnnotationClasses = Objects.requireNonNull(methodNameAnnotationClasses);
    }

    @SafeVarargs
    public AnnotationMethodToMethodNameFunction(Class<? extends Annotation> ... methodNameAnnotationClasses) {
        this.methodNameAnnotationClasses = new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(methodNameAnnotationClasses));
    }

    public Collection<String> getFieldNameList() {
        return this.fieldNameList;
    }

    public Collection<Class<? extends Annotation>> getMethodNameAnnotationClasses() {
        return this.methodNameAnnotationClasses;
    }

    @Override
    public String apply(Method method) {
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            String methodName = this.getName(annotation);
            if (methodName == null || methodName.isEmpty()) continue;
            return methodName;
        }
        return method.getName();
    }

    private String getName(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        for (Class<? extends Annotation> methodNameAnnotationClass : this.methodNameAnnotationClasses) {
            String methodName;
            int hashCode = Objects.hash(annotationType, methodNameAnnotationClass);
            Boolean exist = this.existAnnotationMap.get(hashCode);
            if (exist == null) {
                exist = Objects.equals(annotationType, methodNameAnnotationClass) || ReflectUtil.findAnnotation(annotationType, methodNameAnnotationClass) != null;
                this.existAnnotationMap.put(hashCode, exist != false ? Boolean.TRUE : Boolean.FALSE);
            }
            if (!exist.booleanValue() || (methodName = this.getDirectName(annotation)) == null || methodName.isEmpty()) continue;
            return methodName;
        }
        return null;
    }

    private String getDirectName(Annotation annotation) {
        Map<String, Object> memberValuesMap = ReflectUtil.getAnnotationValueMap(annotation);
        for (String fieldName : this.fieldNameList) {
            Object value = memberValuesMap.get(fieldName);
            if (value instanceof String[]) {
                for (String s : (String[])value) {
                    if (s == null || "".equals(s)) continue;
                    return s;
                }
                continue;
            }
            if (value == null || "".equals(value)) continue;
            return value.toString();
        }
        return null;
    }
}

