/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.core;

import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.SystemPropertyUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.AsciiString;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Packet
implements ReferenceCounted {
    public static final byte TYPE_UNKNOWN = 0;
    public static final byte TYPE_REQUEST = 1;
    public static final byte TYPE_RESPONSE = 2;
    public static final byte TYPE_PING = 3;
    public static final byte TYPE_PONG = 4;
    public static final byte ACK_NO = 0;
    public static final byte ACK_YES = 1;
    private ByteBuf rawPacket;
    private ByteBuf protocolVersion;
    private int packetType = 0;
    private byte ack = 0;
    private Map<AsciiString, ByteBuf> fieldMap;
    private ByteBuf body = Unpooled.EMPTY_BUFFER;
    private AtomicInteger refCnt = new AtomicInteger(1);
    private Debug debug;
    private static boolean debugPacket = SystemPropertyUtil.getBoolean("netty-core.debugPacket", false);

    public Packet() {
    }

    public Packet(int packetType) {
        this.packetType = packetType;
    }

    public ByteBuf getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ByteBuf protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public int getAck() {
        return this.ack;
    }

    public void setAck(byte ack) {
        this.ack = ack;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public void setPacketType(int packetType) {
        this.packetType = packetType;
    }

    public ByteBuf getBody() {
        return this.body;
    }

    public void setBody(ByteBuf body) {
        this.body = body;
    }

    public Map<AsciiString, ByteBuf> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<AsciiString, ByteBuf> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public ByteBuf getRawPacket() {
        return this.rawPacket;
    }

    public void setRawPacket(ByteBuf rawPacket) {
        this.rawPacket = rawPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf putField(AsciiString key, ByteBuf value) {
        boolean release = true;
        try {
            Map<AsciiString, ByteBuf> fieldMap = this.getFieldMap();
            if (fieldMap == null) {
                throw new NullPointerException("fieldMap is null. put key = " + key);
            }
            ByteBuf old = fieldMap.put(key, value);
            release = false;
            ByteBuf byteBuf = old;
            return byteBuf;
        }
        finally {
            if (release) {
                RecyclableUtil.release(value);
            }
        }
    }

    public String toString() {
        Charset charset = Charset.defaultCharset();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{protocolVersion=");
        sb.append(this.protocolVersion == null ? "null" : this.protocolVersion.toString(charset));
        sb.append(", packetType=");
        sb.append(this.packetType);
        sb.append(", ack=");
        sb.append(this.ack);
        sb.append(", bodyLength=");
        sb.append(this.body == null ? "null" : Integer.valueOf(this.body.readableBytes()));
        sb.append(", fieldMap=");
        if (this.fieldMap == null) {
            sb.append("null");
        } else {
            block5: {
                Iterator<Map.Entry<AsciiString, ByteBuf>> i = this.fieldMap.entrySet().iterator();
                if (i.hasNext()) {
                    sb.append('{');
                    while (true) {
                        Map.Entry<AsciiString, ByteBuf> e = i.next();
                        sb.append((CharSequence)e.getKey());
                        sb.append('=');
                        sb.append(e.getValue().toString(charset));
                        if (!i.hasNext()) {
                            sb.append('}');
                            break block5;
                        }
                        sb.append(',').append(' ');
                    }
                }
                sb.append("{}");
            }
            sb.append('}');
        }
        return sb.toString();
    }

    protected AtomicInteger getRefCntAtomic() {
        return this.refCnt;
    }

    public final int refCnt() {
        return this.refCnt.get();
    }

    public final ReferenceCounted retain() {
        return this.retain(1);
    }

    public final ReferenceCounted retain(int increment) {
        this.refCnt.addAndGet(increment);
        return this;
    }

    public final ReferenceCounted touch() {
        return this;
    }

    public final ReferenceCounted touch(Object hint) {
        return this;
    }

    public final boolean release() {
        return this.release(1);
    }

    public final boolean release(int decrement) {
        int oldRef = this.refCnt.getAndAdd(-decrement);
        if (oldRef == decrement) {
            this.deallocate();
            return true;
        }
        if (oldRef < decrement || oldRef - decrement > oldRef) {
            this.refCnt.getAndAdd(decrement);
            throw new IllegalReferenceCountException(oldRef, -decrement);
        }
        return false;
    }

    protected void deallocate() {
        RecyclableUtil.release(this.rawPacket);
        RecyclableUtil.release(this.protocolVersion);
        if (this.fieldMap != null && this.fieldMap.size() > 0) {
            for (Map.Entry<AsciiString, ByteBuf> entry : this.fieldMap.entrySet()) {
                RecyclableUtil.release(entry.getValue());
            }
            this.fieldMap.clear();
        }
        RecyclableUtil.release(this.body);
        this.rawPacket = null;
        this.protocolVersion = null;
        this.body = null;
        if (this.debug != null) {
            Debug.access$002(this.debug, new Throwable().getStackTrace());
            this.debug.releaseThread = Thread.currentThread();
        }
    }

    public Debug getDebug() {
        if (debugPacket && this.debug == null) {
            this.debug = new Debug();
        }
        return this.debug;
    }

    public static boolean isDebugPacket() {
        return debugPacket;
    }

    protected static class Debug {
        private volatile Thread instanceThread;
        private volatile String instancePacket;
        private volatile Thread releaseThread;
        private volatile StackTraceElement[] releaseStackTrace;

        protected Debug() {
        }

        public StackTraceElement[] getReleaseStackTrace() {
            return this.releaseStackTrace;
        }

        public String getInstancePacket() {
            return this.instancePacket;
        }

        public Thread getInstanceThread() {
            return this.instanceThread;
        }

        public Thread getReleaseThread() {
            return this.releaseThread;
        }

        public void setInstancePacket(String instancePacket) {
            this.instancePacket = instancePacket;
        }

        public void setInstanceThread(Thread instanceThread) {
            this.instanceThread = instanceThread;
        }

        public void setReleaseStackTrace(StackTraceElement[] releaseStackTrace) {
            this.releaseStackTrace = releaseStackTrace;
        }

        public void setReleaseThread(Thread releaseThread) {
            this.releaseThread = releaseThread;
        }

        public String toString() {
            return "Debug{instanceThread=" + this.instanceThread + ", instancePacket='" + this.instancePacket + '\'' + ", releaseThread=" + this.releaseThread + ", releaseStackTrace=" + Arrays.toString(this.releaseStackTrace) + '}';
        }

        static /* synthetic */ StackTraceElement[] access$002(Debug x0, StackTraceElement[] x1) {
            x0.releaseStackTrace = x1;
            return x1;
        }
    }
}

