/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave;

import it.sauronsoftware.jave.DefaultFFMPEGLocator;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.EncoderProgressListener;
import it.sauronsoftware.jave.EncodingAttributes;
import it.sauronsoftware.jave.FFMPEGExecutor;
import it.sauronsoftware.jave.FFMPEGLocator;
import it.sauronsoftware.jave.InputFormatException;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.RBufferedReader;
import it.sauronsoftware.jave.audio.AudioAttributes;
import it.sauronsoftware.jave.audio.AudioInfo;
import it.sauronsoftware.jave.enumers.AudioMergeTypeEnum;
import it.sauronsoftware.jave.video.VideoAttributes;
import it.sauronsoftware.jave.video.VideoInfo;
import it.sauronsoftware.jave.video.VideoSize;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Encoder {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^\\s*([D ])([E ])\\s+([\\w,]+)\\s+.+$");
    private static final Pattern ENCODER_DECODER_PATTERN = Pattern.compile("^\\s*([D ])([E ])([AVS]).{3}\\s+(.+)$", 2);
    private static final Pattern PROGRESS_INFO_PATTERN = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\\S+)\\s*", 2);
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)x(\\d+)", 2);
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("([\\d.]+)\\s+(?:fps|tb\\(r\\))", 2);
    private static final Pattern BIT_RATE_PATTERN = Pattern.compile("(\\d+)\\s+kb/s", 2);
    private static final Pattern SAMPLING_RATE_PATTERN = Pattern.compile("(\\d+)\\s+Hz", 2);
    private static final Pattern CHANNELS_PATTERN = Pattern.compile("(mono|stereo)", 2);
    private static final Pattern SUCCESS_PATTERN = Pattern.compile("^\\s*video\\:\\S+\\s+audio\\:\\S+\\s+global headers\\:\\S+.*$", 2);
    private FFMPEGLocator locator;

    public Encoder() {
        this.locator = new DefaultFFMPEGLocator();
    }

    public Encoder(FFMPEGLocator locator) {
        this.locator = locator;
    }

    public String[] getAudioDecoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        String decoderFlag = matcher.group(1);
                        String audioVideoFlag = matcher.group(3);
                        if (!"D".equals(decoderFlag) || !"A".equals(audioVideoFlag)) continue;
                        String name = matcher.group(4);
                        res.add(name);
                        continue;
                    }
                    break;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getAudioEncoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        String encoderFlag = matcher.group(2);
                        String audioVideoFlag = matcher.group(3);
                        if (!"E".equals(encoderFlag) || !"A".equals(audioVideoFlag)) continue;
                        String name = matcher.group(4);
                        res.add(name);
                        continue;
                    }
                    break;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getVideoDecoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        String decoderFlag = matcher.group(1);
                        String audioVideoFlag = matcher.group(3);
                        if (!"D".equals(decoderFlag) || !"V".equals(audioVideoFlag)) continue;
                        String name = matcher.group(4);
                        res.add(name);
                        continue;
                    }
                    break;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getVideoEncoders() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = ENCODER_DECODER_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        String encoderFlag = matcher.group(2);
                        String audioVideoFlag = matcher.group(3);
                        if (!"E".equals(encoderFlag) || !"V".equals(audioVideoFlag)) continue;
                        String name = matcher.group(4);
                        res.add(name);
                        continue;
                    }
                    break;
                }
                if (!line.trim().equals("Codecs:")) continue;
                evaluate = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getSupportedEncodingFormats() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = FORMAT_PATTERN.matcher(line);
                    if (!matcher.matches()) break;
                    String encoderFlag = matcher.group(2);
                    if (!"E".equals(encoderFlag)) continue;
                    String aux = matcher.group(3);
                    StringTokenizer st = new StringTokenizer(aux, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        if (res.contains(token)) continue;
                        res.add(token);
                    }
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                evaluate = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    public String[] getSupportedDecodingFormats() throws EncoderException {
        ArrayList<String> res = new ArrayList<String>();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-formats");
        try {
            String line;
            ffmpeg.execute();
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getInputStream()));
            boolean evaluate = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (evaluate) {
                    Matcher matcher = FORMAT_PATTERN.matcher(line);
                    if (!matcher.matches()) break;
                    String decoderFlag = matcher.group(1);
                    if (!"D".equals(decoderFlag)) continue;
                    String aux = matcher.group(3);
                    StringTokenizer st = new StringTokenizer(aux, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim();
                        if (res.contains(token)) continue;
                        res.add(token);
                    }
                    continue;
                }
                if (!line.trim().equals("File formats:")) continue;
                evaluate = true;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
        int size = res.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = (String)res.get(i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultimediaInfo getInfo(File source) throws InputFormatException, EncoderException {
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(source.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            RBufferedReader reader = null;
            reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            MultimediaInfo multimediaInfo = this.parseMultimediaInfo(source, reader);
            return multimediaInfo;
        }
        finally {
            ffmpeg.destroy();
        }
    }

    private MultimediaInfo parseMultimediaInfo(File source, RBufferedReader reader) throws InputFormatException, EncoderException {
        Pattern p1 = Pattern.compile("^\\s*Input #0, (\\w+).+$\\s*", 2);
        Pattern p2 = Pattern.compile("^\\s*Duration: (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d).*$", 2);
        Pattern p3 = Pattern.compile("^\\s*Stream #\\S+: ((?:Audio)|(?:Video)|(?:Data)): (.*)\\s*$", 2);
        MultimediaInfo info = null;
        try {
            String line;
            int step = 0;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (step == 0) {
                    String token = source.getAbsolutePath() + ": ";
                    if (line.startsWith(token)) {
                        String message = line.substring(token.length());
                        throw new InputFormatException(message);
                    }
                    Matcher m2 = p1.matcher(line);
                    if (m2.matches()) {
                        String format = m2.group(1);
                        info = new MultimediaInfo();
                        info.setFormat(format);
                        ++step;
                    }
                } else if (step == 1) {
                    m = p2.matcher(line);
                    if (m.matches()) {
                        long hours = Integer.parseInt(m.group(1));
                        long minutes = Integer.parseInt(m.group(2));
                        long seconds = Integer.parseInt(m.group(3));
                        long dec = Integer.parseInt(m.group(4));
                        long duration = dec * 100L + seconds * 1000L + minutes * 60L * 1000L + hours * 60L * 60L * 1000L;
                        info.setDuration(duration);
                        ++step;
                    }
                } else if (step == 2) {
                    m = p3.matcher(line);
                    if (m.matches()) {
                        Matcher m2;
                        String token;
                        StringTokenizer st;
                        String type = m.group(1);
                        String specs = m.group(2);
                        if ("Video".equalsIgnoreCase(type)) {
                            VideoInfo video = new VideoInfo();
                            st = new StringTokenizer(specs, ",");
                            int i = 0;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken().trim();
                                if (i == 0) {
                                    video.setDecoder(token);
                                } else {
                                    boolean parsed = false;
                                    m2 = SIZE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int width = Integer.parseInt(m2.group(1));
                                        int height = Integer.parseInt(m2.group(2));
                                        video.setSize(new VideoSize(width, height));
                                        parsed = true;
                                    }
                                    m2 = FRAME_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        try {
                                            float frameRate = Float.parseFloat(m2.group(1));
                                            video.setFrameRate(frameRate);
                                        }
                                        catch (NumberFormatException frameRate) {
                                            // empty catch block
                                        }
                                        parsed = true;
                                    }
                                    m2 = BIT_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int bitRate = Integer.parseInt(m2.group(1));
                                        video.setBitRate(bitRate);
                                        parsed = true;
                                    }
                                }
                                ++i;
                            }
                            info.setVideo(video);
                        } else if ("Audio".equalsIgnoreCase(type)) {
                            AudioInfo audio = new AudioInfo();
                            st = new StringTokenizer(specs, ",");
                            int i = 0;
                            while (st.hasMoreTokens()) {
                                token = st.nextToken().trim();
                                if (i == 0) {
                                    audio.setDecoder(token);
                                } else {
                                    boolean parsed = false;
                                    m2 = SAMPLING_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int samplingRate = Integer.parseInt(m2.group(1));
                                        audio.setSamplingRate(samplingRate);
                                        parsed = true;
                                    }
                                    m2 = CHANNELS_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        String ms = m2.group(1);
                                        if ("mono".equalsIgnoreCase(ms)) {
                                            audio.setChannels(1);
                                        } else if ("stereo".equalsIgnoreCase(ms)) {
                                            audio.setChannels(2);
                                        }
                                        parsed = true;
                                    }
                                    m2 = BIT_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int bitRate = Integer.parseInt(m2.group(1));
                                        audio.setBitRate(bitRate);
                                        parsed = true;
                                    }
                                }
                                ++i;
                            }
                            info.setAudio(audio);
                        }
                    } else {
                        step = 3;
                    }
                }
                if (step != 3) continue;
                reader.reinsertLine(line);
                break;
            }
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        if (info == null) {
            throw new InputFormatException();
        }
        return info;
    }

    private Hashtable parseProgressInfoLine(String line) {
        Hashtable<String, String> table = null;
        Matcher m = PROGRESS_INFO_PATTERN.matcher(line);
        while (m.find()) {
            if (table == null) {
                table = new Hashtable<String, String>();
            }
            String key = m.group(1);
            String value = m.group(2);
            table.put(key, value);
        }
        return table;
    }

    public void encode(File source, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encode(source, target, attributes, null);
    }

    public void encode(File source, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String duration;
        String startTime;
        String codec;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        if (attributes.getFflags() != null && attributes.getFflags().length() > 0) {
            ffmpeg.addArgument("-fflags");
            ffmpeg.addArgument(attributes.getFflags());
        }
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(source.getAbsolutePath());
        if (attributes.getMetadataSv() != null && attributes.getMetadataSv().length() > 0) {
            ffmpeg.addArgument("-metadata:s:v");
            ffmpeg.addArgument(attributes.getMetadataSv());
        }
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (videoAttributes == null) {
            ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            codec = videoAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-vcodec");
                ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                ffmpeg.addArgument("-vtag");
                ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-b");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                ffmpeg.addArgument("-r");
                ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                ffmpeg.addArgument("-s");
                ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + String.valueOf(size.getHeight()));
            }
            if ((startTime = videoAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = videoAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (audioAttributes == null) {
            ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            codec = audioAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-acodec");
                ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-ab");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                ffmpeg.addArgument("-ac");
                ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                ffmpeg.addArgument("-ar");
                ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                ffmpeg.addArgument("-vol");
                ffmpeg.addArgument(String.valueOf(volume));
            }
            if ((startTime = audioAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = audioAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (videoAttributes != null && videoAttributes.getQv() != null && videoAttributes.getQv().length() > 0) {
            ffmpeg.addArgument("-q:v");
            ffmpeg.addArgument(videoAttributes.getQv());
        }
        if (videoAttributes != null && videoAttributes.getVf() != null && videoAttributes.getVf().length() > 0) {
            ffmpeg.addArgument("-vf");
            ffmpeg.addArgument(videoAttributes.getVf());
        }
        if (videoAttributes != null && videoAttributes.getBv() != null && videoAttributes.getBv().length() > 0) {
            ffmpeg.addArgument("-b:v");
            ffmpeg.addArgument(videoAttributes.getBv());
        }
        if (videoAttributes != null && videoAttributes.getBufsize() != null && videoAttributes.getBufsize().length() > 0) {
            ffmpeg.addArgument("-bufsize");
            ffmpeg.addArgument(videoAttributes.getBufsize());
        }
        if (videoAttributes != null && videoAttributes.getMaxrate() != null && videoAttributes.getMaxrate().length() > 0) {
            ffmpeg.addArgument("-maxrate");
            ffmpeg.addArgument(videoAttributes.getMaxrate());
        }
        if (audioAttributes != null && audioAttributes.getAf() != null && audioAttributes.getAf().length() > 0) {
            ffmpeg.addArgument("-af");
            ffmpeg.addArgument(audioAttributes.getAf());
        }
        if (formatAttribute != null && formatAttribute.length() > 0) {
            ffmpeg.addArgument("-f");
            ffmpeg.addArgument(formatAttribute);
        }
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            this.processErrorOutput(attributes, reader, source, listener);
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    protected void processErrorOutput(EncodingAttributes attributes, BufferedReader errorReader, File source, EncoderProgressListener listener) throws EncoderException, IOException {
        String line;
        long duration;
        String lastWarning = null;
        long progress = 0L;
        Float offsetAttribute = attributes.getOffset();
        MultimediaInfo info = this.parseMultimediaInfo(source, (RBufferedReader)errorReader);
        Float durationAttribute = attributes.getDuration();
        if (durationAttribute != null) {
            duration = Math.round(durationAttribute.floatValue() * 1000.0f);
        } else {
            duration = info.getDuration();
            if (offsetAttribute != null) {
                duration -= (long)Math.round(offsetAttribute.floatValue() * 1000.0f);
            }
        }
        if (listener != null) {
            listener.sourceInfo(info);
        }
        int step = 0;
        while ((line = errorReader.readLine()) != null) {
            int dot;
            String time;
            System.out.println(line);
            if (step == 0) {
                if (line.startsWith("WARNING: ")) {
                    if (listener != null) {
                        listener.message(line);
                    }
                } else {
                    if (!line.startsWith("Output #0")) {
                        throw new EncoderException(line);
                    }
                    ++step;
                }
            } else if (step == 1 && !line.startsWith("  ")) {
                ++step;
            }
            if (step == 2) {
                if (!line.startsWith("Stream mapping:")) {
                    throw new EncoderException(line);
                }
                ++step;
            } else if (step == 3 && !line.startsWith("  ")) {
                ++step;
            }
            if (step != 4 || (line = line.trim()).length() <= 0) continue;
            Hashtable table = this.parseProgressInfoLine(line);
            if (table == null) {
                if (listener != null) {
                    listener.message(line);
                }
                lastWarning = line;
                continue;
            }
            if (listener != null && (time = (String)table.get("time")) != null && (dot = time.indexOf(46)) > 0 && dot == time.length() - 2 && duration > 0L) {
                String p1 = time.substring(0, dot);
                String p2 = time.substring(dot + 1);
                try {
                    long i1 = Long.parseLong(p1);
                    long i2 = Long.parseLong(p2);
                    progress = i1 * 1000L + i2 * 100L;
                    int perm = Math.round(progress * 1000L / duration);
                    if (perm > 1000) {
                        perm = 1000;
                    }
                    listener.progress(perm);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            lastWarning = null;
        }
        if (lastWarning != null && !SUCCESS_PATTERN.matcher(lastWarning).matches()) {
            throw new EncoderException(lastWarning);
        }
    }

    public void encodeMergeAudio(List<File> sourceList, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encodeMergeAudio(sourceList, target, attributes, null);
    }

    public void encodeMergeAudio(List<File> sourceList, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        AudioMergeTypeEnum mergeType = audioAttributes.getMergeType();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        for (File source : sourceList) {
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(source.getAbsolutePath());
        }
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (mergeType != null && AudioMergeTypeEnum.SPLIT_JOINT == mergeType) {
            ffmpeg.addArgument("-filter_complex");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < sourceList.size(); ++i) {
                sb.append("[").append(i).append(":0]");
            }
            sb.append("concat=n=").append(sourceList.size());
            sb.append(":v=0:a=1[out]");
            ffmpeg.addArgument(sb.toString());
            ffmpeg.addArgument("-map");
            ffmpeg.addArgument("[out]");
        }
        if (mergeType != null && AudioMergeTypeEnum.ADMIX == mergeType) {
            ffmpeg.addArgument("-filter_complex");
            ffmpeg.addArgument("amix=inputs=" + sourceList.size());
        }
        if (audioAttributes != null && audioAttributes.getAb() != null) {
            ffmpeg.addArgument("-ab");
            ffmpeg.addArgument(audioAttributes.getAb());
        }
        if (formatAttribute != null) {
            ffmpeg.addArgument("-f");
            ffmpeg.addArgument(formatAttribute);
        }
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            this.processErrorOutput(attributes, reader, null, listener);
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    public void encodeMergeVideoAndAudio(List<File> files, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encodeMergeVideoAndAudio(files, target, attributes, null);
    }

    public void encodeMergeVideoAndAudio(List<File> files, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String duration;
        String startTime;
        String codec;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        for (File file : files) {
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(file.getAbsolutePath());
        }
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (videoAttributes == null) {
            ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            codec = videoAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-vcodec");
                ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                ffmpeg.addArgument("-vtag");
                ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-b");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                ffmpeg.addArgument("-r");
                ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                ffmpeg.addArgument("-s");
                ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + String.valueOf(size.getHeight()));
            }
            if ((startTime = videoAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = videoAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (audioAttributes == null) {
            ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            codec = audioAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-acodec");
                ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-ab");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                ffmpeg.addArgument("-ac");
                ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                ffmpeg.addArgument("-ar");
                ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                ffmpeg.addArgument("-vol");
                ffmpeg.addArgument(String.valueOf(volume));
            }
            if ((startTime = audioAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = audioAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        ffmpeg.addArgument("-strict");
        ffmpeg.addArgument("experimental");
        if (videoAttributes != null && videoAttributes.getMergeType().getIndex() == 2) {
            ffmpeg.addArgument("-map");
            ffmpeg.addArgument("0:v:0");
            ffmpeg.addArgument("-map");
            ffmpeg.addArgument("1:a:0");
        }
        if (formatAttribute != null) {
            ffmpeg.addArgument("-f");
            ffmpeg.addArgument(formatAttribute);
        }
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            this.processErrorOutput(attributes, reader, null, listener);
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    public void encodeMergeVideoByDamaging(List<File> files, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encodeMergeVideoByDamaging(files, target, attributes, null);
    }

    public void encodeMergeVideoByDamaging(List<File> files, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String duration;
        String startTime;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("\u8bf7\u4f20\u5165\u8981\u5408\u5e76\u7684\u6587\u4ef6");
        }
        for (File file : files) {
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(file.getAbsolutePath());
        }
        ffmpeg.addArgument("-filter_complex");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.size(); ++i) {
            sb.append("[").append(i).append(":0] ");
            sb.append("[").append(i).append(":1] ");
        }
        sb.append("concat=n=").append(files.size()).append(":v=1:a=1 [v] [a]");
        ffmpeg.addArgument(sb.toString());
        ffmpeg.addArgument("-map");
        ffmpeg.addArgument("[v]");
        ffmpeg.addArgument("-map");
        ffmpeg.addArgument("[a]");
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (videoAttributes == null) {
            ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            String codec = videoAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-vcodec");
                ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                ffmpeg.addArgument("-vtag");
                ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-b");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                ffmpeg.addArgument("-r");
                ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                ffmpeg.addArgument("-s");
                ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + String.valueOf(size.getHeight()));
            }
            if ((startTime = videoAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = videoAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (audioAttributes == null) {
            ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            String codec = audioAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-acodec");
                ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-ab");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                ffmpeg.addArgument("-ac");
                ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                ffmpeg.addArgument("-ar");
                ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                ffmpeg.addArgument("-vol");
                ffmpeg.addArgument(String.valueOf(volume));
            }
            if ((startTime = audioAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = audioAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (formatAttribute != null) {
            ffmpeg.addArgument("-f");
            ffmpeg.addArgument(formatAttribute);
        }
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            this.processErrorOutput(attributes, reader, null, listener);
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }

    public void encodeMergeVideoByLossless(File txtFile, File target, EncodingAttributes attributes) throws IllegalArgumentException, InputFormatException, EncoderException {
        this.encodeMergeVideoByLossless(txtFile, target, attributes, null);
    }

    public void encodeMergeVideoByLossless(File txtFile, File target, EncodingAttributes attributes, EncoderProgressListener listener) throws IllegalArgumentException, InputFormatException, EncoderException {
        String duration;
        String startTime;
        String codec;
        String formatAttribute = attributes.getFormat();
        Float offsetAttribute = attributes.getOffset();
        Float durationAttribute = attributes.getDuration();
        AudioAttributes audioAttributes = attributes.getAudioAttributes();
        VideoAttributes videoAttributes = attributes.getVideoAttributes();
        if (audioAttributes == null && videoAttributes == null) {
            throw new IllegalArgumentException("Both audio and video attributes are null");
        }
        target = target.getAbsoluteFile();
        target.getParentFile().mkdirs();
        FFMPEGExecutor ffmpeg = this.locator.createExecutor();
        if (offsetAttribute != null) {
            ffmpeg.addArgument("-ss");
            ffmpeg.addArgument(String.valueOf(offsetAttribute.floatValue()));
        }
        ffmpeg.addArgument("-f");
        ffmpeg.addArgument("concat");
        ffmpeg.addArgument("-safe");
        ffmpeg.addArgument("0");
        ffmpeg.addArgument("-i");
        ffmpeg.addArgument(txtFile.getAbsolutePath());
        if (durationAttribute != null) {
            ffmpeg.addArgument("-t");
            ffmpeg.addArgument(String.valueOf(durationAttribute.floatValue()));
        }
        if (videoAttributes == null) {
            ffmpeg.addArgument("-vn");
        } else {
            VideoSize size;
            Integer frameRate;
            Integer bitRate;
            String tag;
            codec = videoAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-vcodec");
                ffmpeg.addArgument(codec);
            }
            if ((tag = videoAttributes.getTag()) != null) {
                ffmpeg.addArgument("-vtag");
                ffmpeg.addArgument(tag);
            }
            if ((bitRate = videoAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-b");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((frameRate = videoAttributes.getFrameRate()) != null) {
                ffmpeg.addArgument("-r");
                ffmpeg.addArgument(String.valueOf(frameRate));
            }
            if ((size = videoAttributes.getSize()) != null) {
                ffmpeg.addArgument("-s");
                ffmpeg.addArgument(String.valueOf(size.getWidth()) + "x" + String.valueOf(size.getHeight()));
            }
            if ((startTime = videoAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = videoAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (audioAttributes == null) {
            ffmpeg.addArgument("-an");
        } else {
            Integer volume;
            Integer samplingRate;
            Integer channels;
            Integer bitRate;
            codec = audioAttributes.getCodec();
            if (codec != null) {
                ffmpeg.addArgument("-acodec");
                ffmpeg.addArgument(codec);
            }
            if ((bitRate = audioAttributes.getBitRate()) != null) {
                ffmpeg.addArgument("-ab");
                ffmpeg.addArgument(String.valueOf(bitRate));
            }
            if ((channels = audioAttributes.getChannels()) != null) {
                ffmpeg.addArgument("-ac");
                ffmpeg.addArgument(String.valueOf(channels));
            }
            if ((samplingRate = audioAttributes.getSamplingRate()) != null) {
                ffmpeg.addArgument("-ar");
                ffmpeg.addArgument(String.valueOf(samplingRate));
            }
            if ((volume = audioAttributes.getVolume()) != null) {
                ffmpeg.addArgument("-vol");
                ffmpeg.addArgument(String.valueOf(volume));
            }
            if ((startTime = audioAttributes.getStartTime()) != null) {
                ffmpeg.addArgument("-ss");
                ffmpeg.addArgument(startTime);
            }
            if ((duration = audioAttributes.getDuration()) != null) {
                ffmpeg.addArgument("-t");
                ffmpeg.addArgument(duration);
            }
        }
        if (formatAttribute != null) {
            ffmpeg.addArgument("-f");
            ffmpeg.addArgument(formatAttribute);
        }
        ffmpeg.addArgument("-y");
        ffmpeg.addArgument(target.getAbsolutePath());
        try {
            ffmpeg.execute();
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        try {
            RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
            this.processErrorOutput(attributes, reader, txtFile, listener);
        }
        catch (IOException e) {
            throw new EncoderException(e);
        }
        finally {
            ffmpeg.destroy();
        }
    }
}

