/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.EncryptableMapPropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceMethodInterceptor;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.InterceptionMode;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class EnableEncryptablePropertySourcesPostProcessor
implements BeanFactoryPostProcessor,
PriorityOrdered {
    private static final Logger LOG = LoggerFactory.getLogger(EnableEncryptablePropertySourcesPostProcessor.class);
    private ConfigurableEnvironment environment;
    private InterceptionMode interceptionMode;

    public EnableEncryptablePropertySourcesPostProcessor(ConfigurableEnvironment environment, InterceptionMode interceptionMode) {
        this.environment = environment;
        this.interceptionMode = interceptionMode;
    }

    private <T> PropertySource<T> makeEncryptable(PropertySource<T> propertySource, ConfigurableListableBeanFactory registry) {
        StringEncryptor encryptor = (StringEncryptor)registry.getBean(StringEncryptor.class);
        PropertySource<T> encryptablePropertySource = this.interceptionMode == InterceptionMode.PROXY ? this.proxyPropertySource(propertySource, encryptor) : this.instantiatePropertySource(propertySource, encryptor);
        LOG.info("Converting PropertySource {}[{}] to {}", new Object[]{propertySource.getName(), propertySource.getClass().getName(), encryptablePropertySource.getClass().getSimpleName()});
        return encryptablePropertySource;
    }

    private <T> PropertySource<T> proxyPropertySource(PropertySource<T> propertySource, StringEncryptor encryptor) {
        if (propertySource instanceof CommandLinePropertySource) {
            return this.instantiatePropertySource(propertySource, encryptor);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(propertySource.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setTarget(propertySource);
        proxyFactory.addAdvice(new EncryptablePropertySourceMethodInterceptor(encryptor));
        return (PropertySource)proxyFactory.getProxy();
    }

    private <T> PropertySource<T> instantiatePropertySource(PropertySource<T> propertySource, StringEncryptor encryptor) {
        EncryptablePropertySource<Map<String, Object>> encryptablePropertySource = propertySource instanceof MapPropertySource ? new EncryptableMapPropertySourceWrapper((MapPropertySource)propertySource, encryptor) : (propertySource instanceof EnumerablePropertySource ? new EncryptableEnumerablePropertySourceWrapper((EnumerablePropertySource)propertySource, encryptor) : new EncryptablePropertySourceWrapper<T>(propertySource, encryptor));
        return encryptablePropertySource;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        LOG.info("Post-processing PropertySource instances");
        MutablePropertySources propSources = this.environment.getPropertySources();
        StreamSupport.stream(propSources.spliterator(), false).filter(ps -> !(ps instanceof EncryptablePropertySource)).map(s -> this.makeEncryptable((PropertySource)s, beanFactory)).collect(Collectors.toList()).forEach(ps -> propSources.replace(ps.getName(), ps));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

