/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDCT_3D {
    private int slices;
    private int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private double[] t;
    private DoubleDCT_1D dctSlices;
    private DoubleDCT_1D dctRows;
    private DoubleDCT_1D dctColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDCT_3D(int slices, int rows, int columns) {
        if (slices <= 1 || rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceStride = rows * columns;
        this.rowStride = columns;
        if (slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(slices) && ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = slices;
            if (this.nt < rows) {
                this.nt = rows;
            }
            this.nt *= 4;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (columns == 2) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
        }
        this.dctSlices = new DoubleDCT_1D(slices);
        this.dctRows = slices == rows ? this.dctSlices : new DoubleDCT_1D(rows);
        this.dctColumns = slices == columns ? this.dctSlices : (rows == columns ? this.dctRows : new DoubleDCT_1D(columns));
    }

    public void forward(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.forward(a, idx1 + r * DoubleDCT_3D.this.rowStride, scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int idx3;
                                int r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.forward(temp, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx1 = r * DoubleDCT_3D.this.rowStride;
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int idx3;
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.forward(temp, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int c;
            int idx1;
            int s = 0;
            while (s < this.slices) {
                int idx12 = s * this.sliceStride;
                int r = 0;
                while (r < this.rows) {
                    this.dctColumns.forward(a, idx12 + r * this.rowStride, scale);
                    ++r;
                }
                ++s;
            }
            double[] temp = new double[this.rows];
            int s2 = 0;
            while (s2 < this.slices) {
                idx1 = s2 * this.sliceStride;
                c = 0;
                while (c < this.columns) {
                    int r = 0;
                    while (r < this.rows) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                        ++r;
                    }
                    this.dctRows.forward(temp, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                        ++r;
                    }
                    ++c;
                }
                ++s2;
            }
            temp = new double[this.slices];
            int r = 0;
            while (r < this.rows) {
                idx1 = r * this.rowStride;
                c = 0;
                while (c < this.columns) {
                    int s3 = 0;
                    while (s3 < this.slices) {
                        idx3 = s3 * this.sliceStride + idx1 + c;
                        temp[s3] = a[idx3];
                        ++s3;
                    }
                    this.dctSlices.forward(temp, scale);
                    s3 = 0;
                    while (s3 < this.slices) {
                        idx3 = s3 * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s3];
                        ++s3;
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    public void forward(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.forward(a[s][r], scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    temp[r] = a[s][r][c];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.forward(temp, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    a[s][r][c] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    temp[s] = a[s][r][c];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.forward(temp, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    a[s][r][c] = temp[s];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int r;
            int s = 0;
            while (s < this.slices) {
                r = 0;
                while (r < this.rows) {
                    this.dctColumns.forward(a[s][r], scale);
                    ++r;
                }
                ++s;
            }
            double[] temp = new double[this.rows];
            int s2 = 0;
            while (s2 < this.slices) {
                c = 0;
                while (c < this.columns) {
                    int r2 = 0;
                    while (r2 < this.rows) {
                        temp[r2] = a[s2][r2][c];
                        ++r2;
                    }
                    this.dctRows.forward(temp, scale);
                    r2 = 0;
                    while (r2 < this.rows) {
                        a[s2][r2][c] = temp[r2];
                        ++r2;
                    }
                    ++c;
                }
                ++s2;
            }
            temp = new double[this.slices];
            r = 0;
            while (r < this.rows) {
                c = 0;
                while (c < this.columns) {
                    int s3 = 0;
                    while (s3 < this.slices) {
                        temp[s3] = a[s3][r][c];
                        ++s3;
                    }
                    this.dctSlices.forward(temp, scale);
                    s3 = 0;
                    while (s3 < this.slices) {
                        a[s3][r][c] = temp[s3];
                        ++s3;
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.inverse(a, idx1 + r * DoubleDCT_3D.this.rowStride, scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int idx1 = s * DoubleDCT_3D.this.sliceStride;
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int idx3;
                                int r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.inverse(temp, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx3 = idx1 + r * DoubleDCT_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int idx1 = r * DoubleDCT_3D.this.rowStride;
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int idx3;
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(temp, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx3 = s * DoubleDCT_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int c;
            int idx1;
            int s = 0;
            while (s < this.slices) {
                int idx12 = s * this.sliceStride;
                int r = 0;
                while (r < this.rows) {
                    this.dctColumns.inverse(a, idx12 + r * this.rowStride, scale);
                    ++r;
                }
                ++s;
            }
            double[] temp = new double[this.rows];
            int s2 = 0;
            while (s2 < this.slices) {
                idx1 = s2 * this.sliceStride;
                c = 0;
                while (c < this.columns) {
                    int r = 0;
                    while (r < this.rows) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                        ++r;
                    }
                    this.dctRows.inverse(temp, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                        ++r;
                    }
                    ++c;
                }
                ++s2;
            }
            temp = new double[this.slices];
            int r = 0;
            while (r < this.rows) {
                idx1 = r * this.rowStride;
                c = 0;
                while (c < this.columns) {
                    int s3 = 0;
                    while (s3 < this.slices) {
                        idx3 = s3 * this.sliceStride + idx1 + c;
                        temp[s3] = a[idx3];
                        ++s3;
                    }
                    this.dctSlices.inverse(temp, scale);
                    s3 = 0;
                    while (s3 < this.slices) {
                        idx3 = s3 * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s3];
                        ++s3;
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    public void inverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            int l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.inverse(a[s][r], scale);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            l = 0;
            while (l < nthreads) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.rows];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    temp[r] = a[s][r][c];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.inverse(temp, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    a[s][r][c] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            l = 0;
            while (l < nthreads) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDCT_3D.this.slices];
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < DoubleDCT_3D.this.columns) {
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    temp[s] = a[s][r][c];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(temp, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    a[s][r][c] = temp[s];
                                    ++s;
                                }
                                ++c;
                            }
                            ++r;
                        }
                    }
                });
                ++l;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int r;
            int s = 0;
            while (s < this.slices) {
                r = 0;
                while (r < this.rows) {
                    this.dctColumns.inverse(a[s][r], scale);
                    ++r;
                }
                ++s;
            }
            double[] temp = new double[this.rows];
            int s2 = 0;
            while (s2 < this.slices) {
                c = 0;
                while (c < this.columns) {
                    int r2 = 0;
                    while (r2 < this.rows) {
                        temp[r2] = a[s2][r2][c];
                        ++r2;
                    }
                    this.dctRows.inverse(temp, scale);
                    r2 = 0;
                    while (r2 < this.rows) {
                        a[s2][r2][c] = temp[r2];
                        ++r2;
                    }
                    ++c;
                }
                ++s2;
            }
            temp = new double[this.slices];
            r = 0;
            while (r < this.rows) {
                c = 0;
                while (c < this.columns) {
                    int s3 = 0;
                    while (s3 < this.slices) {
                        temp[s3] = a[s3][r][c];
                        ++s3;
                    }
                    this.dctSlices.inverse(temp, scale);
                    s3 = 0;
                    while (s3 < this.slices) {
                        a[s3][r][c] = temp[s3];
                        ++s3;
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[] a, boolean scale) {
        if (isgn == -1) {
            int s = 0;
            while (s < this.slices) {
                int idx1;
                int idx0 = s * this.sliceStride;
                int r = 0;
                while (r < this.rows) {
                    this.dctColumns.forward(a, idx0 + r * this.rowStride, scale);
                    ++r;
                }
                if (this.columns > 2) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r2 = 0;
                        while (r2 < this.rows) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            this.t[r2] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                            ++r2;
                        }
                        this.dctRows.forward(this.t, 0, scale);
                        this.dctRows.forward(this.t, this.rows, scale);
                        this.dctRows.forward(this.t, 2 * this.rows, scale);
                        this.dctRows.forward(this.t, 3 * this.rows, scale);
                        r2 = 0;
                        while (r2 < this.rows) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = this.t[r2];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                            ++r2;
                        }
                        c += 4;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        this.t[r] = a[idx1];
                        this.t[this.rows + r] = a[idx1 + 1];
                        ++r;
                    }
                    this.dctRows.forward(this.t, 0, scale);
                    this.dctRows.forward(this.t, this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        a[idx1] = this.t[r];
                        a[idx1 + 1] = this.t[this.rows + r];
                        ++r;
                    }
                }
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int idx1;
                int idx0 = s * this.sliceStride;
                int r = 0;
                while (r < this.rows) {
                    this.dctColumns.inverse(a, idx0 + r * this.rowStride, scale);
                    ++r;
                }
                if (this.columns > 2) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r3 = 0;
                        while (r3 < this.rows) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            this.t[r3] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                            ++r3;
                        }
                        this.dctRows.inverse(this.t, 0, scale);
                        this.dctRows.inverse(this.t, this.rows, scale);
                        this.dctRows.inverse(this.t, 2 * this.rows, scale);
                        this.dctRows.inverse(this.t, 3 * this.rows, scale);
                        r3 = 0;
                        while (r3 < this.rows) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = this.t[r3];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                            ++r3;
                        }
                        c += 4;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        this.t[r] = a[idx1];
                        this.t[this.rows + r] = a[idx1 + 1];
                        ++r;
                    }
                    this.dctRows.inverse(this.t, 0, scale);
                    this.dctRows.inverse(this.t, this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        idx1 = idx0 + r * this.rowStride;
                        a[idx1] = this.t[r];
                        a[idx1 + 1] = this.t[this.rows + r];
                        ++r;
                    }
                }
                ++s;
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a, boolean scale) {
        if (isgn == -1) {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    this.dctColumns.forward(a[s][r], scale);
                    ++r;
                }
                if (this.columns > 2) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r2 = 0;
                        while (r2 < this.rows) {
                            idx2 = this.rows + r2;
                            this.t[r2] = a[s][r2][c];
                            this.t[idx2] = a[s][r2][c + 1];
                            this.t[idx2 + this.rows] = a[s][r2][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r2][c + 3];
                            ++r2;
                        }
                        this.dctRows.forward(this.t, 0, scale);
                        this.dctRows.forward(this.t, this.rows, scale);
                        this.dctRows.forward(this.t, 2 * this.rows, scale);
                        this.dctRows.forward(this.t, 3 * this.rows, scale);
                        r2 = 0;
                        while (r2 < this.rows) {
                            idx2 = this.rows + r2;
                            a[s][r2][c] = this.t[r2];
                            a[s][r2][c + 1] = this.t[idx2];
                            a[s][r2][c + 2] = this.t[idx2 + this.rows];
                            a[s][r2][c + 3] = this.t[idx2 + 2 * this.rows];
                            ++r2;
                        }
                        c += 4;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        this.t[r] = a[s][r][0];
                        this.t[this.rows + r] = a[s][r][1];
                        ++r;
                    }
                    this.dctRows.forward(this.t, 0, scale);
                    this.dctRows.forward(this.t, this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        a[s][r][0] = this.t[r];
                        a[s][r][1] = this.t[this.rows + r];
                        ++r;
                    }
                }
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    this.dctColumns.inverse(a[s][r], scale);
                    ++r;
                }
                if (this.columns > 2) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r3 = 0;
                        while (r3 < this.rows) {
                            idx2 = this.rows + r3;
                            this.t[r3] = a[s][r3][c];
                            this.t[idx2] = a[s][r3][c + 1];
                            this.t[idx2 + this.rows] = a[s][r3][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r3][c + 3];
                            ++r3;
                        }
                        this.dctRows.inverse(this.t, 0, scale);
                        this.dctRows.inverse(this.t, this.rows, scale);
                        this.dctRows.inverse(this.t, 2 * this.rows, scale);
                        this.dctRows.inverse(this.t, 3 * this.rows, scale);
                        r3 = 0;
                        while (r3 < this.rows) {
                            idx2 = this.rows + r3;
                            a[s][r3][c] = this.t[r3];
                            a[s][r3][c + 1] = this.t[idx2];
                            a[s][r3][c + 2] = this.t[idx2 + this.rows];
                            a[s][r3][c + 3] = this.t[idx2 + 2 * this.rows];
                            ++r3;
                        }
                        c += 4;
                    }
                } else if (this.columns == 2) {
                    r = 0;
                    while (r < this.rows) {
                        this.t[r] = a[s][r][0];
                        this.t[this.rows + r] = a[s][r][1];
                        ++r;
                    }
                    this.dctRows.inverse(this.t, 0, scale);
                    this.dctRows.inverse(this.t, this.rows, scale);
                    r = 0;
                    while (r < this.rows) {
                        a[s][r][0] = this.t[r];
                        a[s][r][1] = this.t[this.rows + r];
                        ++r;
                    }
                }
                ++s;
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    int r = 0;
                    while (r < this.rows) {
                        int idx0 = r * this.rowStride;
                        int c = 0;
                        while (c < this.columns) {
                            int idx2;
                            int idx1;
                            int s = 0;
                            while (s < this.slices) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                this.t[s] = a[idx1];
                                this.t[idx2] = a[idx1 + 1];
                                this.t[idx2 + this.slices] = a[idx1 + 2];
                                this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                                ++s;
                            }
                            this.dctSlices.forward(this.t, 0, scale);
                            this.dctSlices.forward(this.t, this.slices, scale);
                            this.dctSlices.forward(this.t, 2 * this.slices, scale);
                            this.dctSlices.forward(this.t, 3 * this.slices, scale);
                            s = 0;
                            while (s < this.slices) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                a[idx1] = this.t[s];
                                a[idx1 + 1] = this.t[idx2];
                                a[idx1 + 2] = this.t[idx2 + this.slices];
                                a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                                ++s;
                            }
                            c += 4;
                        }
                        ++r;
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                int r = 0;
                while (r < this.rows) {
                    int idx1;
                    int idx0 = r * this.rowStride;
                    int s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                        ++s;
                    }
                    this.dctSlices.forward(this.t, 0, scale);
                    this.dctSlices.forward(this.t, this.slices, scale);
                    s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                        ++s;
                    }
                    ++r;
                }
                break block19;
            }
            if (this.columns > 2) {
                int r = 0;
                while (r < this.rows) {
                    int idx0 = r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int idx1;
                        int s = 0;
                        while (s < this.slices) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            this.t[s] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.slices] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                            ++s;
                        }
                        this.dctSlices.inverse(this.t, 0, scale);
                        this.dctSlices.inverse(this.t, this.slices, scale);
                        this.dctSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dctSlices.inverse(this.t, 3 * this.slices, scale);
                        s = 0;
                        while (s < this.slices) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            a[idx1] = this.t[s];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.slices];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                            ++s;
                        }
                        c += 4;
                    }
                    ++r;
                }
            } else if (this.columns == 2) {
                int r = 0;
                while (r < this.rows) {
                    int idx1;
                    int idx0 = r * this.rowStride;
                    int s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                        ++s;
                    }
                    this.dctSlices.inverse(this.t, 0, scale);
                    this.dctSlices.inverse(this.t, this.slices, scale);
                    s = 0;
                    while (s < this.slices) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                        ++s;
                    }
                    ++r;
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    int r = 0;
                    while (r < this.rows) {
                        int c = 0;
                        while (c < this.columns) {
                            int idx2;
                            int s = 0;
                            while (s < this.slices) {
                                idx2 = this.slices + s;
                                this.t[s] = a[s][r][c];
                                this.t[idx2] = a[s][r][c + 1];
                                this.t[idx2 + this.slices] = a[s][r][c + 2];
                                this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                                ++s;
                            }
                            this.dctSlices.forward(this.t, 0, scale);
                            this.dctSlices.forward(this.t, this.slices, scale);
                            this.dctSlices.forward(this.t, 2 * this.slices, scale);
                            this.dctSlices.forward(this.t, 3 * this.slices, scale);
                            s = 0;
                            while (s < this.slices) {
                                idx2 = this.slices + s;
                                a[s][r][c] = this.t[s];
                                a[s][r][c + 1] = this.t[idx2];
                                a[s][r][c + 2] = this.t[idx2 + this.slices];
                                a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                                ++s;
                            }
                            c += 4;
                        }
                        ++r;
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                int r = 0;
                while (r < this.rows) {
                    int s = 0;
                    while (s < this.slices) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                        ++s;
                    }
                    this.dctSlices.forward(this.t, 0, scale);
                    this.dctSlices.forward(this.t, this.slices, scale);
                    s = 0;
                    while (s < this.slices) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                        ++s;
                    }
                    ++r;
                }
                break block19;
            }
            if (this.columns > 2) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int s = 0;
                        while (s < this.slices) {
                            idx2 = this.slices + s;
                            this.t[s] = a[s][r][c];
                            this.t[idx2] = a[s][r][c + 1];
                            this.t[idx2 + this.slices] = a[s][r][c + 2];
                            this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                            ++s;
                        }
                        this.dctSlices.inverse(this.t, 0, scale);
                        this.dctSlices.inverse(this.t, this.slices, scale);
                        this.dctSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dctSlices.inverse(this.t, 3 * this.slices, scale);
                        s = 0;
                        while (s < this.slices) {
                            idx2 = this.slices + s;
                            a[s][r][c] = this.t[s];
                            a[s][r][c + 1] = this.t[idx2];
                            a[s][r][c + 2] = this.t[idx2 + this.slices];
                            a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                            ++s;
                        }
                        c += 4;
                    }
                    ++r;
                }
            } else if (this.columns == 2) {
                int r = 0;
                while (r < this.rows) {
                    int s = 0;
                    while (s < this.slices) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                        ++s;
                    }
                    this.dctSlices.inverse(this.t, 0, scale);
                    this.dctSlices.inverse(this.t, this.slices, scale);
                    s = 0;
                    while (s < this.slices) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                        ++s;
                    }
                    ++r;
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int s = n0;
                        while (s < DoubleDCT_3D.this.slices) {
                            int idx1;
                            int idx0 = s * DoubleDCT_3D.this.sliceStride;
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.forward(a, idx0 + r * DoubleDCT_3D.this.rowStride, scale);
                                ++r;
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                int c = 0;
                                while (c < DoubleDCT_3D.this.columns) {
                                    int idx2;
                                    int r2 = 0;
                                    while (r2 < DoubleDCT_3D.this.rows) {
                                        idx1 = idx0 + r2 * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDCT_3D.this.rows + r2;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r2] = a[idx1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 3];
                                        ++r2;
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt, scale);
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.rows, scale);
                                    r2 = 0;
                                    while (r2 < DoubleDCT_3D.this.rows) {
                                        idx1 = idx0 + r2 * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDCT_3D.this.rows + r2;
                                        a[idx1] = DoubleDCT_3D.this.t[startt + r2];
                                        a[idx1 + 1] = DoubleDCT_3D.this.t[idx2];
                                        a[idx1 + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.rows];
                                        a[idx1 + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                        ++r2;
                                    }
                                    c += 4;
                                }
                            } else if (DoubleDCT_3D.this.columns == 2) {
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r] = a[idx1];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[idx1 + 1];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                    a[idx1] = DoubleDCT_3D.this.t[startt + r];
                                    a[idx1 + 1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.rows + r];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    } else {
                        int s = n0;
                        while (s < DoubleDCT_3D.this.slices) {
                            int idx1;
                            int idx0 = s * DoubleDCT_3D.this.sliceStride;
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.inverse(a, idx0 + r * DoubleDCT_3D.this.rowStride, scale);
                                ++r;
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                int c = 0;
                                while (c < DoubleDCT_3D.this.columns) {
                                    int idx2;
                                    int j = 0;
                                    while (j < DoubleDCT_3D.this.rows) {
                                        idx1 = idx0 + j * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDCT_3D.this.rows + j;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + j] = a[idx1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[idx1 + 3];
                                        ++j;
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.rows, scale);
                                    j = 0;
                                    while (j < DoubleDCT_3D.this.rows) {
                                        idx1 = idx0 + j * DoubleDCT_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDCT_3D.this.rows + j;
                                        a[idx1] = DoubleDCT_3D.this.t[startt + j];
                                        a[idx1 + 1] = DoubleDCT_3D.this.t[idx2];
                                        a[idx1 + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.rows];
                                        a[idx1 + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                        ++j;
                                    }
                                    c += 4;
                                }
                            } else if (DoubleDCT_3D.this.columns == 2) {
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r] = a[idx1];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[idx1 + 1];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    idx1 = idx0 + r * DoubleDCT_3D.this.rowStride;
                                    a[idx1] = DoubleDCT_3D.this.t[startt + r];
                                    a[idx1 + 1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.rows + r];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int s = n0;
                        while (s < DoubleDCT_3D.this.slices) {
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.forward(a[s][r], scale);
                                ++r;
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                int c = 0;
                                while (c < DoubleDCT_3D.this.columns) {
                                    int idx2;
                                    int r2 = 0;
                                    while (r2 < DoubleDCT_3D.this.rows) {
                                        idx2 = startt + DoubleDCT_3D.this.rows + r2;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r2] = a[s][r2][c];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[s][r2][c + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r2][c + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r2][c + 3];
                                        ++r2;
                                    }
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt, scale);
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.rows, scale);
                                    r2 = 0;
                                    while (r2 < DoubleDCT_3D.this.rows) {
                                        idx2 = startt + DoubleDCT_3D.this.rows + r2;
                                        a[s][r2][c] = DoubleDCT_3D.this.t[startt + r2];
                                        a[s][r2][c + 1] = DoubleDCT_3D.this.t[idx2];
                                        a[s][r2][c + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.rows];
                                        a[s][r2][c + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                        ++r2;
                                    }
                                    c += 4;
                                }
                            } else if (DoubleDCT_3D.this.columns == 2) {
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r] = a[s][r][0];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[s][r][1];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctRows.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    a[s][r][0] = DoubleDCT_3D.this.t[startt + r];
                                    a[s][r][1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.rows + r];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    } else {
                        int s = n0;
                        while (s < DoubleDCT_3D.this.slices) {
                            int r = 0;
                            while (r < DoubleDCT_3D.this.rows) {
                                DoubleDCT_3D.this.dctColumns.inverse(a[s][r], scale);
                                ++r;
                            }
                            if (DoubleDCT_3D.this.columns > 2) {
                                int c = 0;
                                while (c < DoubleDCT_3D.this.columns) {
                                    int idx2;
                                    int r3 = 0;
                                    while (r3 < DoubleDCT_3D.this.rows) {
                                        idx2 = startt + DoubleDCT_3D.this.rows + r3;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r3] = a[s][r3][c];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[s][r3][c + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r3][c + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).rows] = a[s][r3][c + 3];
                                        ++r3;
                                    }
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.rows, scale);
                                    DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.rows, scale);
                                    r3 = 0;
                                    while (r3 < DoubleDCT_3D.this.rows) {
                                        idx2 = startt + DoubleDCT_3D.this.rows + r3;
                                        a[s][r3][c] = DoubleDCT_3D.this.t[startt + r3];
                                        a[s][r3][c + 1] = DoubleDCT_3D.this.t[idx2];
                                        a[s][r3][c + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.rows];
                                        a[s][r3][c + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.rows];
                                        ++r3;
                                    }
                                    c += 4;
                                }
                            } else if (DoubleDCT_3D.this.columns == 2) {
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + r] = a[s][r][0];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).rows + r] = a[s][r][1];
                                    ++r;
                                }
                                DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctRows.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.rows, scale);
                                r = 0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    a[s][r][0] = DoubleDCT_3D.this.t[startt + r];
                                    a[s][r][1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.rows + r];
                                    ++r;
                                }
                            }
                            s += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (DoubleDCT_3D.this.columns <= 2) break block18;
                                int r = n0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    int idx0 = r * DoubleDCT_3D.this.rowStride;
                                    int c = 0;
                                    while (c < DoubleDCT_3D.this.columns) {
                                        int idx2;
                                        int idx1;
                                        int s = 0;
                                        while (s < DoubleDCT_3D.this.slices) {
                                            idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + DoubleDCT_3D.this.slices + s;
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[idx1];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[idx1 + 1];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 2];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 3];
                                            ++s;
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.slices, scale);
                                        s = 0;
                                        while (s < DoubleDCT_3D.this.slices) {
                                            idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + DoubleDCT_3D.this.slices + s;
                                            a[idx1] = DoubleDCT_3D.this.t[startt + s];
                                            a[idx1 + 1] = DoubleDCT_3D.this.t[idx2];
                                            a[idx1 + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.slices];
                                            a[idx1 + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                            ++s;
                                        }
                                        c += 4;
                                    }
                                    r += nthreads;
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columns != 2) break block19;
                            int r = n0;
                            while (r < DoubleDCT_3D.this.rows) {
                                int idx1;
                                int idx0 = r * DoubleDCT_3D.this.rowStride;
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[idx1];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[idx1 + 1];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    a[idx1] = DoubleDCT_3D.this.t[startt + s];
                                    a[idx1 + 1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.slices + s];
                                    ++s;
                                }
                                r += nthreads;
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columns > 2) {
                            int r = n0;
                            while (r < DoubleDCT_3D.this.rows) {
                                int idx0 = r * DoubleDCT_3D.this.rowStride;
                                int c = 0;
                                while (c < DoubleDCT_3D.this.columns) {
                                    int idx2;
                                    int idx1;
                                    int s = 0;
                                    while (s < DoubleDCT_3D.this.slices) {
                                        idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + DoubleDCT_3D.this.slices + s;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[idx1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[idx1 + 3];
                                        ++s;
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.slices, scale);
                                    s = 0;
                                    while (s < DoubleDCT_3D.this.slices) {
                                        idx1 = s * DoubleDCT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + DoubleDCT_3D.this.slices + s;
                                        a[idx1] = DoubleDCT_3D.this.t[startt + s];
                                        a[idx1 + 1] = DoubleDCT_3D.this.t[idx2];
                                        a[idx1 + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.slices];
                                        a[idx1 + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                        ++s;
                                    }
                                    c += 4;
                                }
                                r += nthreads;
                            }
                        } else if (DoubleDCT_3D.this.columns == 2) {
                            int r = n0;
                            while (r < DoubleDCT_3D.this.rows) {
                                int idx1;
                                int idx0 = r * DoubleDCT_3D.this.rowStride;
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[idx1];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[idx1 + 1];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    idx1 = s * DoubleDCT_3D.this.sliceStride + idx0;
                                    a[idx1] = DoubleDCT_3D.this.t[startt + s];
                                    a[idx1 + 1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.slices + s];
                                    ++s;
                                }
                                r += nthreads;
                            }
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (DoubleDCT_3D.this.columns <= 2) break block18;
                                int r = n0;
                                while (r < DoubleDCT_3D.this.rows) {
                                    int c = 0;
                                    while (c < DoubleDCT_3D.this.columns) {
                                        int idx2;
                                        int s = 0;
                                        while (s < DoubleDCT_3D.this.slices) {
                                            idx2 = startt + DoubleDCT_3D.this.slices + s;
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[s][r][c];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[s][r][c + 1];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 2];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 3];
                                            ++s;
                                        }
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.slices, scale);
                                        DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.slices, scale);
                                        s = 0;
                                        while (s < DoubleDCT_3D.this.slices) {
                                            idx2 = startt + DoubleDCT_3D.this.slices + s;
                                            a[s][r][c] = DoubleDCT_3D.this.t[startt + s];
                                            a[s][r][c + 1] = DoubleDCT_3D.this.t[idx2];
                                            a[s][r][c + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.slices];
                                            a[s][r][c + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                            ++s;
                                        }
                                        c += 4;
                                    }
                                    r += nthreads;
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.columns != 2) break block19;
                            int r = n0;
                            while (r < DoubleDCT_3D.this.rows) {
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[s][r][0];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[s][r][1];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctSlices.forward(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    a[s][r][0] = DoubleDCT_3D.this.t[startt + s];
                                    a[s][r][1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.slices + s];
                                    ++s;
                                }
                                r += nthreads;
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.columns > 2) {
                            int r = n0;
                            while (r < DoubleDCT_3D.this.rows) {
                                int c = 0;
                                while (c < DoubleDCT_3D.this.columns) {
                                    int idx2;
                                    int s = 0;
                                    while (s < DoubleDCT_3D.this.slices) {
                                        idx2 = startt + DoubleDCT_3D.this.slices + s;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[s][r][c];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2] = a[s][r][c + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[idx2 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).slices] = a[s][r][c + 3];
                                        ++s;
                                    }
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + 2 * DoubleDCT_3D.this.slices, scale);
                                    DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + 3 * DoubleDCT_3D.this.slices, scale);
                                    s = 0;
                                    while (s < DoubleDCT_3D.this.slices) {
                                        idx2 = startt + DoubleDCT_3D.this.slices + s;
                                        a[s][r][c] = DoubleDCT_3D.this.t[startt + s];
                                        a[s][r][c + 1] = DoubleDCT_3D.this.t[idx2];
                                        a[s][r][c + 2] = DoubleDCT_3D.this.t[idx2 + DoubleDCT_3D.this.slices];
                                        a[s][r][c + 3] = DoubleDCT_3D.this.t[idx2 + 2 * DoubleDCT_3D.this.slices];
                                        ++s;
                                    }
                                    c += 4;
                                }
                                r += nthreads;
                            }
                        } else if (DoubleDCT_3D.this.columns == 2) {
                            int r = n0;
                            while (r < DoubleDCT_3D.this.rows) {
                                int s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + s] = a[s][r][0];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[startt + ((DoubleDCT_3D)DoubleDCT_3D.this).slices + s] = a[s][r][1];
                                    ++s;
                                }
                                DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt, scale);
                                DoubleDCT_3D.this.dctSlices.inverse(DoubleDCT_3D.this.t, startt + DoubleDCT_3D.this.slices, scale);
                                s = 0;
                                while (s < DoubleDCT_3D.this.slices) {
                                    a[s][r][0] = DoubleDCT_3D.this.t[startt + s];
                                    a[s][r][1] = DoubleDCT_3D.this.t[startt + DoubleDCT_3D.this.slices + s];
                                    ++s;
                                }
                                r += nthreads;
                            }
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }
}

