/*
 * Decompiled with CFR 0.152.
 */
package com.plexpt.chatgpt.listener;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.plexpt.chatgpt.entity.chat.ChatChoice;
import com.plexpt.chatgpt.entity.chat.ChatCompletionResponse;
import com.plexpt.chatgpt.entity.chat.Message;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamListener
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractStreamListener.class);
    protected String lastMessage = "";
    protected Consumer<String> onComplate = s -> {};

    public abstract void onMsg(String var1);

    public abstract void onError(Throwable var1, String var2);

    public void onOpen(EventSource eventSource, Response response) {
    }

    public void onClosed(EventSource eventSource) {
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        if (data.equals("[DONE]")) {
            this.onComplate.accept(this.lastMessage);
            return;
        }
        ChatCompletionResponse response = (ChatCompletionResponse)JSON.parseObject((String)data, ChatCompletionResponse.class);
        List<ChatChoice> choices = response.getChoices();
        if (choices == null || choices.isEmpty()) {
            return;
        }
        Message delta = choices.get(0).getDelta();
        String text = delta.getContent();
        if (text != null) {
            this.lastMessage = this.lastMessage + text;
            this.onMsg(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(EventSource eventSource, Throwable throwable, Response response) {
        try {
            String overloadedText;
            log.error("Stream connection error: {}", throwable);
            String responseText = "";
            if (Objects.nonNull(response)) {
                responseText = response.body().string();
            }
            log.error("response\uff1a{}", (Object)responseText);
            String forbiddenText = "Your access was terminated due to violation of our policies";
            if (StrUtil.contains((CharSequence)responseText, (CharSequence)forbiddenText)) {
                log.error("Chat session has been terminated due to policy violation");
                log.error("\u68c0\u6d4b\u5230\u53f7\u88ab\u5c01\u4e86");
            }
            if (StrUtil.contains((CharSequence)responseText, (CharSequence)(overloadedText = "That model is currently overloaded with other requests."))) {
                log.error("\u68c0\u6d4b\u5230\u5b98\u65b9\u8d85\u8f7d\u4e86\uff0c\u8d76\u7d27\u4f18\u5316\u4f60\u7684\u4ee3\u7801\uff0c\u505a\u91cd\u8bd5\u5427");
            }
            this.onError(throwable, responseText);
        }
        catch (Exception e) {
            log.warn("onFailure error:{}", (Throwable)e);
        }
        finally {
            eventSource.cancel();
        }
    }

    public void setOnComplate(Consumer<String> onComplate) {
        this.onComplate = onComplate;
    }

    public Consumer<String> getOnComplate() {
        return this.onComplate;
    }
}

