/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import com.github.liaochong.myexcel.utils.PropertyUtil;
import java.lang.reflect.Field;
import java.util.Properties;

public class MappingWriteConverter
implements WriteConverter {
    private final WeakCache<String, Pair<Class, Object>> mappingCache = new WeakCache();

    @Override
    public boolean support(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        ExcelColumnMapping mapping = convertContext.excelColumnMappingMap.get(field);
        return mapping != null && !mapping.mapping.isEmpty();
    }

    @Override
    public Pair<Class, Object> convert(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        ExcelColumnMapping excelColumnMapping = convertContext.excelColumnMappingMap.get(field);
        String cacheKey = excelColumnMapping.mapping + "->" + fieldVal;
        Pair<Class, Object> mapping = this.mappingCache.get(cacheKey);
        if (mapping != null) {
            return mapping;
        }
        Properties properties = PropertyUtil.getProperties(excelColumnMapping);
        String property = properties.getProperty(fieldVal.toString());
        if (property == null) {
            return Pair.of(fieldType, fieldVal);
        }
        Pair<Class, Object> result = Pair.of(String.class, property);
        this.mappingCache.cache(cacheKey, result);
        return result;
    }
}

