/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.XSSFSheetPreXMLHandler;
import com.github.liaochong.myexcel.core.XSSFSheetXMLHandler;
import com.github.liaochong.myexcel.core.context.Hyperlink;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.util.CellAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XSSFSaxReadHandler<T>
extends AbstractReadHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger log = LoggerFactory.getLogger(XSSFSaxReadHandler.class);
    private int count;
    private final XSSFSheetPreXMLHandler.XSSFPreData xssfPreData;

    public XSSFSaxReadHandler(List<T> result, SaxExcelReader.ReadConfig<T> readConfig, XSSFSheetPreXMLHandler.XSSFPreData xssfPreData) {
        super(false, result, readConfig, xssfPreData != null ? xssfPreData.mergeCellMapping : Collections.emptyMap());
        this.xssfPreData = xssfPreData;
    }

    @Override
    public void startRow(int rowNum, boolean newInstance) {
        this.newRow(rowNum, newInstance);
    }

    @Override
    public void endRow(int rowNum) {
        this.handleResult();
        ++this.count;
    }

    @Override
    public void cell(CellAddress cellAddress, String formattedValue) {
        if (this.xssfPreData != null) {
            Hyperlink hyperlink = this.xssfPreData.hyperlinkMapping.get(cellAddress);
            if (hyperlink != null) {
                hyperlink.setLabel(formattedValue);
            }
            this.readContext.setHyperlink(hyperlink);
        }
        int thisCol = cellAddress.getColumn();
        this.handleField(thisCol, formattedValue);
    }

    @Override
    public void endSheet() {
        log.info("Import completed, total number of rows {}.", (Object)this.count);
    }
}

