/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.log;

import com.github.lianjiatech.retrofit.spring.boot.log.GlobalLogProperty;
import com.github.lianjiatech.retrofit.spring.boot.log.LogLevel;
import com.github.lianjiatech.retrofit.spring.boot.log.LogStrategy;
import com.github.lianjiatech.retrofit.spring.boot.log.Logging;
import com.github.lianjiatech.retrofit.spring.boot.log.LoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public class AggregateLoggingInterceptor
extends LoggingInterceptor {
    public AggregateLoggingInterceptor(GlobalLogProperty globalLogProperty) {
        super(globalLogProperty);
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Logging logging = this.findLogging(chain);
        if (!this.needLog(logging)) {
            return chain.proceed(chain.request());
        }
        LogLevel logLevel = logging == null ? this.globalLogProperty.getLogLevel() : logging.logLevel();
        LogStrategy logStrategy = logging == null ? this.globalLogProperty.getLogStrategy() : logging.logStrategy();
        BufferingLogger bufferingLogger = new BufferingLogger(this.matchLogger(logLevel));
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)bufferingLogger).setLevel(HttpLoggingInterceptor.Level.valueOf((String)logStrategy.name()));
        Response response = httpLoggingInterceptor.intercept(chain);
        bufferingLogger.flush();
        return response;
    }

    private static class BufferingLogger
    implements HttpLoggingInterceptor.Logger {
        private StringBuilder buffer = new StringBuilder(System.lineSeparator());
        private final HttpLoggingInterceptor.Logger delegate;

        public BufferingLogger(HttpLoggingInterceptor.Logger delegate) {
            this.delegate = delegate;
        }

        public void log(String message) {
            this.buffer.append(message).append(System.lineSeparator());
        }

        public void flush() {
            this.delegate.log(this.buffer.toString());
            this.buffer = new StringBuilder(System.lineSeparator());
        }
    }
}

