/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core.reactive;

import com.github.lianjiatech.retrofit.spring.boot.core.InternalCallAdapterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

public class MonoCallAdapterFactory
extends CallAdapter.Factory
implements InternalCallAdapterFactory {
    public static final MonoCallAdapterFactory INSTANCE = new MonoCallAdapterFactory();

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (MonoCallAdapterFactory.getRawType((Type)returnType) != Mono.class) {
            return null;
        }
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("Mono return type must be parameterized as Mono<Foo> or Mono<? extends Foo>");
        }
        Type innerType = MonoCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)returnType));
        if (MonoCallAdapterFactory.getRawType((Type)innerType) != Response.class) {
            return new BodyCallAdapter(innerType);
        }
        if (!(innerType instanceof ParameterizedType)) {
            throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
        }
        Type responseType = MonoCallAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)innerType));
        return new ResponseCallAdapter(responseType);
    }

    private MonoCallAdapterFactory() {
    }

    private static class ResponseCallAdapter<R>
    implements CallAdapter<R, Mono<Response<R>>> {
        private final Type responseType;

        public ResponseCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public Mono<Response<R>> adapt(Call<R> call) {
            return Mono.create(monoSink -> call.enqueue((Callback)new ResponseCallback(monoSink)));
        }

        private class ResponseCallback
        implements Callback<R> {
            private final MonoSink<Response<R>> monoSink;

            public ResponseCallback(MonoSink<Response<R>> monoSink) {
                this.monoSink = monoSink;
            }

            public void onResponse(Call<R> call, Response<R> response) {
                this.monoSink.success(response);
            }

            public void onFailure(Call<R> call, Throwable t) {
                this.monoSink.error(t);
            }
        }
    }

    private static class BodyCallAdapter<R>
    implements CallAdapter<R, Mono<R>> {
        private final Type responseType;

        public BodyCallAdapter(Type responseType) {
            this.responseType = responseType;
        }

        public Type responseType() {
            return this.responseType;
        }

        public Mono<R> adapt(Call<R> call) {
            return Mono.create(monoSink -> call.enqueue((Callback)new BodyCallback(monoSink)));
        }

        private class BodyCallback
        implements Callback<R> {
            private final MonoSink<R> monoSink;

            public BodyCallback(MonoSink<R> monoSink) {
                this.monoSink = monoSink;
            }

            public void onResponse(Call<R> call, Response<R> response) {
                if (response.isSuccessful()) {
                    this.monoSink.success(response.body());
                } else {
                    this.monoSink.error((Throwable)new HttpException(response));
                }
            }

            public void onFailure(Call<R> call, Throwable t) {
                this.monoSink.error(t);
            }
        }
    }
}

