/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.core.InternalCallAdapterFactory;
import com.github.lianjiatech.retrofit.spring.boot.exception.RetrofitException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Request;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class BodyCallAdapterFactory
extends CallAdapter.Factory
implements InternalCallAdapterFactory {
    public static final BodyCallAdapterFactory INSTANCE = new BodyCallAdapterFactory();

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Call.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        if (CompletableFuture.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        if (Response.class.isAssignableFrom(BodyCallAdapterFactory.getRawType((Type)returnType))) {
            return null;
        }
        return new BodyCallAdapter(returnType, annotations, retrofit);
    }

    private BodyCallAdapterFactory() {
    }

    static final class BodyCallAdapter<R>
    implements CallAdapter<R, R> {
        private final Type returnType;
        private final Retrofit retrofit;
        private final Annotation[] annotations;

        BodyCallAdapter(Type returnType, Annotation[] annotations, Retrofit retrofit) {
            this.returnType = returnType;
            this.retrofit = retrofit;
            this.annotations = annotations;
        }

        public Type responseType() {
            return this.returnType;
        }

        public R adapt(Call<R> call) {
            Response response;
            Request request = call.request();
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw Objects.requireNonNull(RetrofitException.errorExecuting(request, e));
            }
            if (response.isSuccessful()) {
                return (R)response.body();
            }
            ResponseBody errorBody = response.errorBody();
            if (errorBody == null) {
                return null;
            }
            Converter converter = this.retrofit.responseBodyConverter(this.responseType(), this.annotations);
            try {
                return (R)converter.convert((Object)Objects.requireNonNull(errorBody));
            }
            catch (IOException e) {
                throw Objects.requireNonNull(RetrofitException.errorExecuting(request, e));
            }
        }
    }
}

