/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core;

import com.github.lianjiatech.retrofit.spring.boot.core.ClassPathRetrofitClientScanner;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

public class AutoConfiguredRetrofitScannerRegistrar
implements BeanFactoryAware,
ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(AutoConfiguredRetrofitScannerRegistrar.class);
    private BeanFactory beanFactory;
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (!AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
            log.warn("Could not determine auto-configuration package, automatic retrofit scanning disabled.");
            return;
        }
        List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        ClassPathRetrofitClientScanner scanner = new ClassPathRetrofitClientScanner(registry, this.classLoader);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        Object[] packageArr = packages.toArray(new String[0]);
        log.info("Scan the @RetrofitClient annotated interface using the auto-configuration package. packages={}", (Object)Arrays.toString(packageArr));
        scanner.registerFilters();
        scanner.doScan((String[])packageArr);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

