/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.utils;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ModbusFunctionCode {
    READ_COILS(1),
    READ_DISCRETE_INPUTS(2),
    READ_HOLDING_REGISTERS(3),
    READ_INPUT_REGISTERS(4),
    WRITE_SINGLE_COIL(5),
    WRITE_SINGLE_REGISTER(6),
    READ_EXCEPTION_STATUS(7),
    DIAGNOSTICS(8),
    GET_COMM_EVENT_COUNTER(11),
    GET_COMM_EVENT_LOG(12),
    WRITE_MULTIPLE_COILS(15),
    WRITE_MULTIPLE_REGISTERS(16),
    REPORT_SLAVE_ID(17),
    READ_FILE_RECORD(20),
    WRITE_FILE_RECORD(21),
    MASK_WRITE_REGISTER(22),
    READ_WRITE_MULTIPLE_REGISTERS(23),
    READ_FIFO_QUEUE(24),
    ENCAPSULATED_INTERFACE_TRANSPORT(43),
    UNKNOWN(255);

    private static final int MODBUS_EXCEPTION_FLAG = 128;
    private static final Map<Integer, ModbusFunctionCode> values;
    private final int value;

    private ModbusFunctionCode(int value) {
        this.value = value;
    }

    public static ModbusFunctionCode get(int value) {
        if (ModbusFunctionCode.isException(value)) {
            value &= 0xFFFFFF7F;
        }
        if (values.containsKey(value)) {
            return values.get(value);
        }
        return UNKNOWN;
    }

    public static boolean isException(int value) {
        return (value & 0x80) != 0;
    }

    public static int getExceptionValue(int functionCode) {
        return functionCode | 0x80;
    }

    public int toInt() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    static {
        values = new HashMap<Integer, ModbusFunctionCode>(ModbusFunctionCode.values().length);
        for (ModbusFunctionCode func : ModbusFunctionCode.values()) {
            values.put(func.value, func);
        }
    }
}

