/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class ByteFifo {
    private final ByteArrayOutputStream baos;
    private final ByteArrayInputStream bais;
    private final int capacity;

    public ByteFifo(int size) {
        this.baos = new ByteArrayOutputStream(size);
        this.bais = new ByteArrayInputStream(this.baos.getByteBuffer());
        this.capacity = size;
        this.bais.mark(0);
        this.reset();
    }

    public void reset() {
        this.baos.reset();
        this.bais.reset();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public int size() {
        return this.baos.size();
    }

    public int read() {
        return this.available() > 0 ? this.bais.read() : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.available() < b.length ? 0 : this.bais.read(b);
    }

    public int read(byte[] b, int offset, int length) {
        return this.available() < b.length ? 0 : this.bais.read(b, offset, length);
    }

    public void write(int b) {
        if (this.size() < this.capacity) {
            this.baos.write(b);
        }
    }

    public void write(byte[] b) {
        int available = this.capacity - this.size();
        if (available > 0) {
            int count = b.length < available ? b.length : available;
            this.baos.write(b, 0, count);
        }
    }

    public void write(byte[] b, int off, int len) {
        int available = this.capacity - this.size();
        if (available > 0) {
            int count = len < available ? len : available;
            this.baos.write(b, off, count);
        }
    }

    public int available() {
        return this.size() - (this.capacity - this.bais.available());
    }

    private static class ByteArrayOutputStream
    extends java.io.ByteArrayOutputStream {
        ByteArrayOutputStream(int size) {
            super(size);
        }

        byte[] getByteBuffer() {
            return this.buf;
        }
    }
}

