/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.slave;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.ModbusSlave;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.slave.RequestHandler;

class RequestHandlerTCP
extends RequestHandler {
    RequestHandlerTCP(ModbusSlave slave, ModbusConnection conn) {
        super(slave, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setListening(true);
        try {
            do {
                DataHolder dataHolder = this.getSlave().getDataHolder();
                ModbusTransport transport = this.getConn().getTransport();
                ModbusRequest request = (ModbusRequest)transport.readRequest();
                if (request.getServerAddress() != 255 && request.getServerAddress() != this.getSlave().getServerAddress() && (request.getServerAddress() != 0 || !this.getSlave().isBroadcastEnabled())) continue;
                ModbusResponse response = request.process(dataHolder);
                response.setTransactionId(request.getTransactionId());
                transport.send(response);
            } while (this.isListening());
        }
        catch (ModbusNumberException e) {
            Modbus.log().warning(e.getLocalizedMessage());
        }
        catch (ModbusIOException e) {
            Modbus.log().warning(e.getLocalizedMessage());
        }
        finally {
            this.setListening(false);
            try {
                this.getConn().close();
            }
            catch (ModbusIOException ioe) {
                Modbus.log().warning(ioe.getMessage());
            }
        }
    }
}

