/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.slave;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.ModbusSlave;
import com.invertor.modbus.data.CommStatus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.data.comm.ModbusCommEventSend;
import com.invertor.modbus.exception.ModbusChecksumException;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.request.GetCommEventCounterRequest;
import com.invertor.modbus.msg.request.GetCommEventLogRequest;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.slave.RequestHandler;

class RequestHandlerSerial
extends RequestHandler {
    RequestHandlerSerial(ModbusSlave slave, ModbusConnection conn) {
        super(slave, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setListening(true);
        do {
            DataHolder dataHolder = this.getSlave().getDataHolder();
            CommStatus commStatus = dataHolder.getCommStatus();
            ModbusTransport transport = this.getConn().getTransport();
            try {
                ModbusRequest request = (ModbusRequest)transport.readRequest();
                commStatus.incBusMessageCounter();
                if (!(request instanceof GetCommEventCounterRequest) && !(request instanceof GetCommEventLogRequest)) {
                    commStatus.enter();
                }
                if (request.getServerAddress() == this.getSlave().getServerAddress()) {
                    try {
                        ModbusResponse response = request.process(dataHolder);
                        commStatus.incSlaveMessageCounter();
                        if (response.isException()) {
                            commStatus.addEvent(ModbusCommEventSend.createExceptionSentRead());
                            commStatus.incExErrorCounter();
                        } else if (!(request instanceof GetCommEventCounterRequest) && !(request instanceof GetCommEventLogRequest)) {
                            commStatus.incEventCounter();
                        }
                        if (!commStatus.isListenOnlyMode()) {
                            transport.send(response);
                        }
                        if (!commStatus.isRestartCommunicationsOption()) continue;
                        commStatus.restartCommunicationsOption();
                        this.getSlave().listen();
                        continue;
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        commStatus.incNoResponseCounter();
                        throw e;
                    }
                }
                if (request.getServerAddress() != 0 || !this.getSlave().isBroadcastEnabled()) continue;
                request.process(dataHolder);
            }
            catch (ModbusChecksumException e) {
                commStatus.incCommErrorCounter();
            }
            catch (Exception e) {
                Modbus.log().warning(e.getLocalizedMessage());
            }
            finally {
                commStatus.leave();
            }
        } while (this.isListening());
        try {
            this.getConn().close();
        }
        catch (ModbusIOException e) {
            Modbus.log().warning(e.getMessage());
        }
    }
}

