/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.slave;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.ModbusSlave;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.ModbusConnectionFactory;
import com.invertor.modbus.slave.RequestHandlerTCP;
import com.invertor.modbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ModbusSlaveTCP
extends ModbusSlave
implements Runnable {
    private static final int DEFAULT_POOLS_SIZE = 10;
    private final ExecutorService threadPool;
    private final TcpParameters tcp;
    private Thread mainThread = null;
    private ServerSocket server = null;

    public ModbusSlaveTCP(TcpParameters tcp) {
        this(tcp, 10);
    }

    public ModbusSlaveTCP(TcpParameters tcp, int poolsSize) {
        this.tcp = new TcpParameters(tcp);
        this.threadPool = Executors.newFixedThreadPool(poolsSize);
    }

    public synchronized void listenImpl() throws ModbusIOException {
        try {
            this.server = new ServerSocket(this.tcp.getPort());
            this.mainThread = new Thread(this);
            this.setListening(true);
            this.mainThread.start();
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    public synchronized void shutdownImpl() {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException e) {
            Modbus.log().warning("Something wrong with server socket: " + e.getLocalizedMessage());
        }
        finally {
            this.server = null;
        }
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
        }
        try {
            if (this.mainThread != null) {
                this.mainThread.join(2000L);
                if (this.mainThread.isAlive()) {
                    this.mainThread.interrupt();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.mainThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.isListening()) {
                Socket s = this.server.accept();
                try {
                    ModbusConnection conn = ModbusConnectionFactory.getTcpSlave(s);
                    conn.setReadTimeout(this.getReadTimeout());
                    this.threadPool.execute(new RequestHandlerTCP(this, conn));
                }
                catch (ModbusIOException ioe) {
                    Modbus.log().warning(ioe.getLocalizedMessage());
                    s.close();
                }
            }
        }
        catch (SocketException se) {
            if (this.server != null) {
                if (this.server.isClosed()) {
                    Modbus.log().fine("All right, server socket has been closed:" + se.getLocalizedMessage());
                } else {
                    Modbus.log().warning("Something wrong:" + se.getLocalizedMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.shutdown();
            }
            catch (ModbusIOException e) {
                Modbus.log().warning("Cannot shutdown: " + e.getLocalizedMessage());
            }
        }
    }
}

