/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.slave;

import com.invertor.modbus.ModbusSlave;
import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.slave.RequestHandler;
import com.invertor.modbus.slave.RequestHandlerSerial;

class ModbusSlaveSerial
extends ModbusSlave {
    private final ModbusConnection conn;
    private final RequestHandler requestHandler;
    private Thread mainThread = null;

    ModbusSlaveSerial(ModbusConnection conn) {
        this.conn = conn;
        this.requestHandler = new RequestHandlerSerial(this, conn);
    }

    public synchronized void listenImpl() throws ModbusIOException {
        this.shutdown();
        this.conn.open();
        this.mainThread = new Thread(this.requestHandler);
        this.mainThread.start();
    }

    public synchronized void shutdownImpl() throws ModbusIOException {
        this.requestHandler.setListening(false);
        try {
            if (this.mainThread != null) {
                this.mainThread.join(2000L);
                if (this.mainThread.isAlive()) {
                    this.mainThread.interrupt();
                }
            }
            this.mainThread = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.conn.close();
    }

    ModbusConnection getConn() {
        return this.conn;
    }
}

