/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.slave;

import com.invertor.modbus.net.ModbusConnectionFactory;
import com.invertor.modbus.serial.SerialParameters;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.serial.SerialPortException;
import com.invertor.modbus.serial.SerialUtils;
import com.invertor.modbus.slave.ModbusSlaveSerial;

public class ModbusSlaveRTU
extends ModbusSlaveSerial {
    public ModbusSlaveRTU(SerialParameters sp) throws SerialPortException {
        super(ModbusConnectionFactory.getRTU(SerialUtils.createSerial(sp)));
        int baud_len = 1 + sp.getDataBits() + sp.getStopBits() + (sp.getParity() != SerialPort.Parity.NONE ? 1 : 0);
        double frame_break_len = 3.5;
        int timeout = (int)Math.ceil(3500.0 * (double)baud_len / (double)sp.getBaudRate());
        this.getConn().setReadTimeout(timeout * 10);
    }

    public ModbusSlaveRTU(String device, SerialPort.BaudRate baudRate, int dataBits, int stopBits, SerialPort.Parity parity) throws SerialPortException {
        this(new SerialParameters(device, baudRate, dataBits, stopBits, parity));
    }
}

