/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.serial;

import com.invertor.modbus.serial.SerialParameters;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.serial.SerialPortException;
import java.io.IOException;

public class SerialPortJSSC
extends SerialPort {
    private final jssc.SerialPort port;

    public SerialPortJSSC(SerialParameters sp) throws SerialPortException {
        super(sp);
        this.port = new jssc.SerialPort(sp.getDevice());
    }

    public void write(int b) throws IOException {
        try {
            this.port.writeByte((byte)b);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void write(byte[] bytes) throws IOException {
        try {
            this.port.writeBytes(bytes);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void open() throws SerialPortException {
        try {
            this.port.openPort();
            SerialParameters sp = this.getSerialParameters();
            this.port.setParams(sp.getBaudRate(), sp.getDataBits(), sp.getStopBits(), sp.getParity().getValue());
            this.port.setFlowControlMode(0);
        }
        catch (Exception ex) {
            throw new SerialPortException(ex);
        }
    }

    public int read() throws IOException {
        try {
            if (this.getReadTimeout() > 0) {
                return this.port.readBytes(1, this.getReadTimeout())[0];
            }
            return this.port.readBytes(1)[0];
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            byte[] rb = this.port.readBytes(len, this.getReadTimeout());
            System.arraycopy(rb, 0, b, off, len);
            return rb.length;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void close() {
        if (this.port.isOpened()) {
            try {
                this.port.closePort();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isOpened() {
        return this.port.isOpened();
    }
}

