/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.serial;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.serial.SerialParameters;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.serial.SerialPortAbstractFactory;
import com.invertor.modbus.serial.SerialPortException;
import com.invertor.modbus.serial.SerialPortRXTX;
import gnu.io.CommPortIdentifier;
import gnu.io.RXTXVersion;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialPortFactoryRXTX
implements SerialPortAbstractFactory {
    @Override
    public SerialPort createSerial(SerialParameters sp) throws SerialPortException {
        try {
            Class.forName("gnu.io.SerialPort");
        }
        catch (ClassNotFoundException e) {
            throw new SerialPortException(e);
        }
        return new SerialPortRXTX(sp);
    }

    @Override
    public List<String> getPortIdentifiers() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> list = new ArrayList<String>();
        while (ports.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)ports.nextElement();
            if (id.getPortType() != 4 && id.getPortType() != 1) continue;
            list.add(id.getName());
        }
        return list;
    }

    @Override
    public String getVersion() {
        String version = "information about version is unavailable.";
        try {
            Class.forName("gnu.io.SerialPort");
            version = RXTXVersion.getVersion();
        }
        catch (ClassNotFoundException e) {
            Modbus.log().warning("The RXTX library is not found.");
        }
        return version;
    }
}

