/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.serial;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.serial.SerialParameters;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.serial.SerialPortAbstractFactory;
import com.invertor.modbus.serial.SerialPortException;
import com.invertor.modbus.serial.SerialPortPJC;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PureJavaComm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialPortFactoryPJC
implements SerialPortAbstractFactory {
    @Override
    public SerialPort createSerial(SerialParameters sp) throws SerialPortException {
        try {
            Class.forName("purejavacomm.SerialPort");
        }
        catch (ClassNotFoundException e) {
            throw new SerialPortException(e);
        }
        return new SerialPortPJC(sp);
    }

    @Override
    public List<String> getPortIdentifiers() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> list = new ArrayList<String>();
        while (ports.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)ports.nextElement();
            if (id.getPortType() != 1) continue;
            list.add(id.getName());
        }
        return list;
    }

    @Override
    public String getVersion() {
        String version = "information about version is unavailable.";
        try {
            Class.forName("purejavacomm.PureJavaComm");
            version = PureJavaComm.getVersion();
        }
        catch (ClassNotFoundException e) {
            Modbus.log().warning("The PureJavaComm library is not found.");
        }
        return version;
    }
}

