/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.serial;

import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.serial.SerialParameters;
import com.invertor.modbus.serial.SerialPortException;
import java.io.IOException;

public abstract class SerialPort {
    private final SerialParameters serialParameters;
    private int readTimeout = 1000;

    public SerialPort(SerialParameters sp) throws SerialPortException {
        this.serialParameters = sp;
    }

    public SerialParameters getSerialParameters() {
        return this.serialParameters;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public ModbusOutputStream getOutputStream() {
        return new ModbusOutputStream(){
            private final SerialPort serial;
            {
                this.serial = SerialPort.this;
            }

            public void flush() throws IOException {
                try {
                    if (this.serial.isOpened()) {
                        this.serial.write(this.toByteArray());
                    }
                }
                finally {
                    super.flush();
                }
            }
        };
    }

    public ModbusInputStream getInputStream() {
        return new ModbusInputStream(){
            private final SerialPort serial;
            {
                this.serial = SerialPort.this;
            }

            public int read() throws IOException {
                return this.serial.read() & 0xFF;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int size;
                for (size = 0; size < len; size += this.serial.read(b, size, len - size)) {
                }
                return size;
            }

            public void setReadTimeout(int readTimeout) {
                this.serial.setReadTimeout(readTimeout);
            }
        };
    }

    public abstract void write(int var1) throws IOException;

    public abstract void write(byte[] var1) throws IOException;

    public abstract void open() throws SerialPortException;

    public abstract int read() throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void close();

    public abstract boolean isOpened();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaudRate {
        BAUD_RATE_4800(4800),
        BAUD_RATE_9600(9600),
        BAUD_RATE_14400(14400),
        BAUD_RATE_19200(19200),
        BAUD_RATE_38400(38400),
        BAUD_RATE_57600(57600),
        BAUD_RATE_115200(115200);

        private final int value;

        private BaudRate(int value) {
            this.value = value;
        }

        public static BaudRate getBaudRate(int value) {
            for (BaudRate br : BaudRate.values()) {
                if (br.value != value) continue;
                return br;
            }
            throw new IllegalArgumentException("Illegal baud rate value:" + value);
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parity {
        NONE(0),
        ODD(1),
        EVEN(2),
        MARK(3),
        SPACE(4);

        private final int value;

        private Parity(int value) {
            this.value = value;
        }

        public static Parity getParity(Integer value) {
            for (Parity par : Parity.values()) {
                if (par.value != value) continue;
                return par;
            }
            throw new IllegalArgumentException("Illegal parity value:" + value);
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

