/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.stream.base;

import com.invertor.modbus.utils.ByteFifo;
import com.invertor.modbus.utils.DataUtils;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ModbusOutputStream
extends OutputStream {
    private final ByteFifo fifo = new ByteFifo(256);

    public void write(byte[] b) throws IOException {
        this.fifo.write(b);
    }

    public void write(int b) throws IOException {
        this.fifo.write(b);
    }

    public void flush() throws IOException {
        this.fifo.reset();
    }

    public void writeShortBE(int s) throws IOException {
        this.write(DataUtils.byteHigh(s));
        this.write(DataUtils.byteLow(s));
    }

    public void writeShortLE(int s) throws IOException {
        this.write(DataUtils.byteLow(s));
        this.write(DataUtils.byteHigh(s));
    }

    public byte[] toByteArray() {
        return this.fifo.toByteArray();
    }
}

