/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.stream.base;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ByteFifo;
import com.invertor.modbus.utils.DataUtils;
import java.io.IOException;

public class LoggingOutputStream
extends ModbusOutputStream {
    private static final String LOG_MESSAGE_TITLE = "Frame sent: ";
    private final ModbusOutputStream out;
    private final ByteFifo fifo = new ByteFifo(254);

    public LoggingOutputStream(ModbusOutputStream out) {
        this.out = out;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (Modbus.isLoggingEnabled()) {
            this.fifo.write(b);
        }
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        if (Modbus.isLoggingEnabled()) {
            this.fifo.write(b);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
        this.log();
    }

    public void log() {
        if (Modbus.isLoggingEnabled()) {
            Modbus.log().info(LOG_MESSAGE_TITLE + DataUtils.toAscii(this.fifo.toByteArray()));
            this.fifo.reset();
        }
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }
}

