/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.stream;

import com.invertor.modbus.net.stream.OutputStreamSerial;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.utils.DataUtils;
import java.io.IOException;
import java.nio.charset.Charset;

public class OutputStreamASCII
extends OutputStreamSerial {
    private int lrc = 0;

    public OutputStreamASCII(SerialPort serial) {
        super(serial);
        this.reset();
    }

    public void write(byte[] bytes) throws IOException {
        for (byte b : bytes) {
            this.lrc += b;
        }
        byte[] ascii = DataUtils.toAscii(bytes).getBytes(Charset.forName("ASCII"));
        super.write(ascii);
    }

    public void write(int b) throws IOException {
        this.lrc += (byte)b;
        byte[] bytes = DataUtils.toAscii((byte)b).getBytes(Charset.forName("ASCII"));
        super.write(bytes);
    }

    private void writeChecksum() throws IOException {
        byte[] bytes = DataUtils.toAscii((byte)(-this.lrc)).getBytes(Charset.forName("ASCII"));
        super.write(bytes);
    }

    public void writeRaw(int b) throws IOException {
        super.write(b);
    }

    public void flush() throws IOException {
        this.writeChecksum();
        this.writeRaw(13);
        this.writeRaw(10);
        super.flush();
        this.reset();
    }

    public void reset() {
        try {
            this.lrc = 0;
            this.writeRaw(58);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

