/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.stream;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.net.stream.base.LoggingInputStream;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class InputStreamTCP
extends LoggingInputStream {
    public InputStreamTCP(final Socket s) throws IOException {
        super(new ModbusInputStream(){
            private final Socket socket;
            private final BufferedInputStream in;
            {
                this.socket = s;
                this.in = new BufferedInputStream(s.getInputStream());
            }

            public int read() throws IOException {
                int c = this.in.read();
                if (-1 == c) {
                    throw new IOException();
                }
                return c;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int count = 0;
                int k = 0;
                while (count < len && k != -1) {
                    k = this.in.read(b, off + count, len - count);
                    if (-1 == k) continue;
                    count += k;
                }
                return count;
            }

            public void setReadTimeout(int readTimeout) {
                try {
                    this.socket.setSoTimeout(readTimeout);
                }
                catch (SocketException e) {
                    Modbus.log().warning(e.getLocalizedMessage());
                }
            }

            public void close() throws IOException {
                this.in.close();
            }
        });
    }
}

