/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.stream;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusChecksumException;
import com.invertor.modbus.net.stream.InputStreamSerial;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.utils.DataUtils;
import java.io.IOException;

public class InputStreamASCII
extends InputStreamSerial {
    private int lrc = 0;

    public InputStreamASCII(SerialPort serial) {
        super(serial);
    }

    private void lrcAdd(byte b) {
        this.lrc += b;
    }

    private int lrcGet() {
        return (byte)(-this.lrc);
    }

    public void frameCheck() throws IOException, ModbusChecksumException {
        byte r_lrc = (byte)this.read();
        byte c_lrc = (byte)this.lrcGet();
        int cr = this.readRaw();
        int lf = this.readRaw();
        if (cr != 13 || lf != Modbus.getAsciiMsgDelimiter()) {
            Modbus.log().warning("\\r\\n not received.");
        }
        if (c_lrc != 0 || r_lrc == 0) {
            throw new ModbusChecksumException(r_lrc, c_lrc);
        }
    }

    public void frameInit() throws IOException {
        this.lrc = 0;
        char c = (char)this.readRaw();
        if (c != ':') {
            throw new IOException("no bytes read");
        }
    }

    public int readRaw() throws IOException {
        return super.read();
    }

    public int read() throws IOException {
        char c = (char)this.readRaw();
        int b = DataUtils.fromAscii(c, (char)this.readRaw());
        this.lrcAdd((byte)b);
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            b[i] = (byte)this.read();
        }
        return len;
    }
}

