/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.net.ModbusConnection;
import com.invertor.modbus.net.ModbusConnectionASCII;
import com.invertor.modbus.net.ModbusConnectionRTU;
import com.invertor.modbus.net.ModbusMasterConnectionTCP;
import com.invertor.modbus.net.ModbusSlaveConnectionTCP;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.tcp.TcpParameters;
import java.net.Socket;

public class ModbusConnectionFactory {
    public static ModbusConnection getASCII(SerialPort serial) {
        return new ModbusConnectionASCII(serial);
    }

    public static ModbusConnection getRTU(SerialPort serial) {
        return new ModbusConnectionRTU(serial);
    }

    public static ModbusConnection getTcpMaster(TcpParameters tcpParameters) {
        return new ModbusMasterConnectionTCP(tcpParameters);
    }

    public static ModbusConnection getTcpSlave(Socket socket) throws ModbusIOException {
        return new ModbusSlaveConnectionTCP(socket);
    }
}

