/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteFileRecordResponse
extends ModbusResponse {
    public static final int READ_SUB_REQ_LENGTH = 7;
    private ModbusFileRecord record = null;

    public WriteFileRecordResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteFileRecordResponse(int serverAddress, ModbusFileRecord record) throws ModbusNumberException {
        super(serverAddress);
        this.setFileRecord(record);
    }

    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        if (fifo.read() != 6) {
            throw new ModbusNumberException("Reference type mismatch.");
        }
        int file_number = fifo.readShortBE();
        int record_number = fifo.readShortBE();
        int record_length = fifo.readShortBE();
        byte[] buffer = new byte[record_length * 2];
        if (fifo.read(buffer) != buffer.length) {
            throw new ModbusNumberException(record_length + " bytes expected, but not received.");
        }
        this.record = new ModbusFileRecord(file_number, record_number, DataUtils.toIntArray(buffer));
    }

    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(7 + this.record.getRecordLength() * 2);
        fifo.write(6);
        fifo.writeShortBE(this.record.getFileNumber());
        fifo.writeShortBE(this.record.getRecordNumber());
        fifo.writeShortBE(this.record.getRecordLength());
        fifo.write(DataUtils.toByteArray(this.record.getRegisters()));
    }

    public ModbusFileRecord getFileRecord() {
        return this.record;
    }

    public void setFileRecord(ModbusFileRecord record) {
        this.record = record;
    }

    protected int responseSize() {
        return 1 + 7 * this.record.getRecordLength() * 2;
    }

    public int getFunction() {
        return ModbusFunctionCode.WRITE_FILE_RECORD.toInt();
    }
}

