/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractReadResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;

public class ReadHoldingRegistersResponse
extends AbstractReadResponse {
    private byte[] buffer = new byte[0];

    public ReadHoldingRegistersResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public final byte[] getBytes() {
        return Arrays.copyOf(this.buffer, this.buffer.length);
    }

    public final int[] getRegisters() {
        return DataUtils.toIntArray(this.buffer);
    }

    public final void setBuffer(int[] registers) throws ModbusNumberException {
        this.buffer = DataUtils.toByteArray(registers);
        this.setByteCount(this.buffer.length);
    }

    protected final void readData(ModbusInputStream fifo) throws IOException {
        this.buffer = new byte[this.getByteCount()];
        int size = fifo.read(this.buffer);
        if (size < this.buffer.length) {
            Modbus.log().warning(this.buffer.length + " bytes expected, but " + size + " received.");
        }
    }

    protected final void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.buffer);
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_HOLDING_REGISTERS.toInt();
    }
}

