/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadFifoQueueResponse
extends ModbusResponse {
    private byte[] bytes;

    public ReadFifoQueueResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    private void checkFifoCount(int fifoCount) throws ModbusNumberException {
        if (fifoCount > 31) {
            throw new ModbusNumberException("Fifo count greater than max fifo count", fifoCount);
        }
    }

    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int byteCount = fifo.readShortBE();
        int fifoCount = fifo.readShortBE();
        if (fifoCount * 2 != byteCount) {
            throw new ModbusNumberException("Fifo count not matches bytes*2", fifoCount);
        }
        this.checkFifoCount(fifoCount);
        this.bytes = new byte[byteCount];
        if (fifo.read(this.bytes) != byteCount) {
            throw new IOException("Can't read fifo value register");
        }
    }

    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        int[] r = this.getFifoValueRegister();
        fifo.writeShortBE(r.length * 2);
        fifo.writeShortBE(r.length);
        fifo.write(DataUtils.toByteArray(r));
    }

    protected int responseSize() {
        return 4 + (this.bytes != null ? this.bytes.length : 0);
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_FIFO_QUEUE.toInt();
    }

    public int[] getFifoValueRegister() {
        return DataUtils.toIntArray(this.bytes);
    }

    public void setFifoValueRegister(int[] fifoValueRegister) throws ModbusNumberException {
        this.checkFifoCount(fifoValueRegister.length);
        this.bytes = DataUtils.toByteArray(fifoValueRegister);
    }
}

