/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.AbstractWriteResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class MaskWriteRegisterResponse
extends AbstractWriteResponse {
    private int maskAnd;
    private int maskOr;

    public MaskWriteRegisterResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public MaskWriteRegisterResponse(int serverAddress, int startAddress, int maskAnd, int maskOr) throws ModbusNumberException {
        super(serverAddress, startAddress);
        this.setMaskAnd(maskAnd);
        this.setMaskOr(maskOr);
    }

    protected void readValue(ModbusInputStream fifo) throws IOException {
        this.setMaskAnd(fifo.readShortBE());
        this.setMaskOr(fifo.readShortBE());
    }

    protected void writeValue(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getMaskAnd());
        fifo.writeShortBE(this.getMaskOr());
    }

    public int getFunction() {
        return ModbusFunctionCode.MASK_WRITE_REGISTER.toInt();
    }

    public int getMaskAnd() {
        return this.maskAnd;
    }

    public void setMaskAnd(int maskAnd) {
        this.maskAnd = maskAnd;
    }

    public int getMaskOr() {
        return this.maskOr;
    }

    public void setMaskOr(int maskOr) {
        this.maskOr = maskOr;
    }
}

