/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.base.mei.MEIFactory;
import com.invertor.modbus.msg.base.mei.ModbusEncapsulatedInterface;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.MEITypeCode;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class EncapsulatedInterfaceTransportResponse
extends ModbusResponse {
    private ModbusEncapsulatedInterface mei = null;

    public EncapsulatedInterfaceTransportResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        int meiTypeCode = fifo.read();
        this.setMei(MEIFactory.getMEI(MEITypeCode.get(meiTypeCode)));
        if (this.getMei() == null) {
            throw new ModbusNumberException("Unknown MEI type", meiTypeCode);
        }
        this.getMei().readResponse(fifo);
    }

    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.write(this.getMei().getTypeCode().toInt());
        this.getMei().writeResponse(fifo);
    }

    public ModbusEncapsulatedInterface getMei() {
        return this.mei;
    }

    public void setMei(ModbusEncapsulatedInterface mei) {
        this.mei = mei;
    }

    protected int responseSize() {
        return 1 + (this.mei == null ? 0 : this.mei.getResponseSize());
    }

    public int getFunction() {
        return ModbusFunctionCode.ENCAPSULATED_INTERFACE_TRANSPORT.toInt();
    }
}

