/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.response;

import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DiagnosticsSubFunctionCode;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class DiagnosticsResponse
extends ModbusResponse {
    private DiagnosticsSubFunctionCode subFunctionCode;
    private int subFunctionData = 0;

    public DiagnosticsResponse(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    protected void readResponse(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        this.setSubFunctionCode(DiagnosticsSubFunctionCode.get(fifo.readShortBE()));
        this.setSubFunctionData(fifo.readShortBE());
    }

    protected void writeResponse(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getSubFunctionCode().toInt());
        fifo.writeShortBE(this.getSubFunctionData());
    }

    protected int responseSize() {
        return 4;
    }

    public int getFunction() {
        return ModbusFunctionCode.DIAGNOSTICS.toInt();
    }

    public DiagnosticsSubFunctionCode getSubFunctionCode() {
        return this.subFunctionCode;
    }

    public void setSubFunctionCode(DiagnosticsSubFunctionCode subFunctionCode) {
        this.subFunctionCode = subFunctionCode;
    }

    public int getSubFunctionData() {
        return this.subFunctionData;
    }

    public void setSubFunctionData(int subFunctionData) {
        this.subFunctionData = subFunctionData;
    }
}

