/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractDataRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.WriteSingleRegisterResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class WriteSingleRegisterRequest
extends AbstractDataRequest {
    private int value;

    public WriteSingleRegisterRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteSingleRegisterRequest(int serverAddress, int startAddress, int value) throws ModbusNumberException {
        super(serverAddress, startAddress);
        if (!Modbus.checkRegisterValue(value)) {
            throw new ModbusNumberException("Register value out of range", value);
        }
        this.setValue(value);
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteSingleRegisterResponse response = new WriteSingleRegisterResponse(this.getServerAddress(), this.getStartAddress(), this.getValue());
        try {
            dataHolder.writeHoldingRegister(this.getStartAddress(), this.getValue());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteSingleRegisterResponse)) {
            return false;
        }
        WriteSingleRegisterResponse r = (WriteSingleRegisterResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getValue();
    }

    protected final void readData(ModbusInputStream fifo) throws IOException {
        this.setValue(fifo.readShortBE());
    }

    public int getFunction() {
        return ModbusFunctionCode.WRITE_SINGLE_REGISTER.toInt();
    }

    public final void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getValue());
    }

    protected int dataSize() {
        return 2;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = (short)value & 0xFFFF;
    }
}

