/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.request.WriteSingleRegisterRequest;
import com.invertor.modbus.msg.response.WriteSingleCoilResponse;
import com.invertor.modbus.utils.ModbusFunctionCode;

public final class WriteSingleCoilRequest
extends WriteSingleRegisterRequest {
    public WriteSingleCoilRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteSingleCoilRequest(int serverAddress, int startAddress, boolean coil) throws ModbusNumberException {
        super(serverAddress, startAddress, Modbus.fromCoil(coil));
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteSingleCoilResponse response = new WriteSingleCoilResponse(this.getServerAddress(), this.getStartAddress(), this.getCoil());
        try {
            dataHolder.writeCoil(this.getStartAddress(), this.getCoil());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteSingleCoilResponse)) {
            return false;
        }
        WriteSingleCoilResponse r = (WriteSingleCoilResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getValue();
    }

    private boolean getCoil() {
        return Modbus.toCoil(this.getValue());
    }

    public int getFunction() {
        return ModbusFunctionCode.WRITE_SINGLE_COIL.toInt();
    }
}

