/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractWriteMultipleRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.WriteMultipleRegistersResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.utils.DataUtils;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class WriteMultipleRegistersRequest
extends AbstractWriteMultipleRequest {
    public WriteMultipleRegistersRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public WriteMultipleRegistersRequest(int serverAddress, int startAddress, int[] registers) throws ModbusNumberException {
        super(serverAddress, startAddress, DataUtils.toByteArray(registers), registers.length);
    }

    public WriteMultipleRegistersRequest(int serverAddress, int startAddress, byte[] bytes) throws ModbusNumberException {
        super(serverAddress, startAddress, bytes, bytes.length / 2);
        if (bytes.length % 2 != 0) {
            throw new ModbusNumberException("bytes.length=" + bytes.length + " should be an even number");
        }
    }

    protected boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkWriteRegisterCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + quantity);
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteMultipleRegistersResponse response = new WriteMultipleRegistersResponse(this.getServerAddress(), this.getStartAddress(), this.getQuantity());
        try {
            dataHolder.writeHoldingRegisterRange(this.getStartAddress(), this.getRegisters());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteMultipleRegistersResponse)) {
            return false;
        }
        WriteMultipleRegistersResponse r = (WriteMultipleRegistersResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getQuantity();
    }

    public void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
        super.readData(fifo);
        if (this.getQuantity() * 2 != this.getByteCount()) {
            throw new ModbusNumberException("Byte count not matches quantity*2", this.getByteCount());
        }
        if (!this.checkAddressRange(this.getStartAddress(), this.getQuantity())) {
            throw new ModbusNumberException("Register count greater than max register count", this.getQuantity());
        }
    }

    public int[] getRegisters() {
        return DataUtils.toIntArray(this.getValues());
    }

    public int getFunction() {
        return ModbusFunctionCode.WRITE_MULTIPLE_REGISTERS.toInt();
    }
}

