/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractMultipleRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.ReadHoldingRegistersResponse;
import com.invertor.modbus.utils.ModbusFunctionCode;

public class ReadHoldingRegistersRequest
extends AbstractMultipleRequest {
    public ReadHoldingRegistersRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadHoldingRegistersRequest(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        super(serverAddress, startAddress, quantity);
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadHoldingRegistersResponse response = new ReadHoldingRegistersResponse(this.getServerAddress());
        try {
            int[] range = dataHolder.readHoldingRegisterRange(this.getStartAddress(), this.getQuantity());
            response.setBuffer(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadHoldingRegistersResponse)) {
            return false;
        }
        ReadHoldingRegistersResponse r = (ReadHoldingRegistersResponse)response;
        return r.getByteCount() == this.getQuantity() * 2;
    }

    public boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkReadRegisterCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + quantity);
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_HOLDING_REGISTERS.toInt();
    }
}

