/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusFileRecord;
import com.invertor.modbus.msg.base.ModbusRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.ReadFileRecordResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public final class ReadFileRecordRequest
extends ModbusRequest {
    public static final int READ__SUB_REQ_LENGTH = 7;
    private ModbusFileRecord[] records = null;

    public ReadFileRecordRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadFileRecordRequest(int serverAddress, ModbusFileRecord[] records) throws ModbusNumberException {
        super(serverAddress);
        this.records = Arrays.copyOf(records, records.length);
    }

    public void writeRequest(ModbusOutputStream fifo) throws IOException {
        fifo.write(7 * this.records.length);
        for (ModbusFileRecord record : this.records) {
            fifo.write(6);
            fifo.writeShortBE(record.getFileNumber());
            fifo.writeShortBE(record.getRecordNumber());
            fifo.writeShortBE(record.getRecordLength());
        }
    }

    public void readPDU(ModbusInputStream fifo) throws ModbusNumberException, IOException {
        LinkedList<ModbusFileRecord> records = new LinkedList<ModbusFileRecord>();
        int byteCount = fifo.read();
        if (byteCount > 252) {
            throw new ModbusNumberException("Byte count greater than max allowable");
        }
        for (int read = 0; read < byteCount; read += 7) {
            if (fifo.read() != 6) {
                throw new ModbusNumberException("Reference type mismatch.");
            }
            int file_number = fifo.readShortBE();
            int record_number = fifo.readShortBE();
            int record_length = fifo.readShortBE();
            records.add(new ModbusFileRecord(file_number, record_number, record_length));
        }
        this.records = records.toArray(new ModbusFileRecord[records.size()]);
    }

    public int requestSize() {
        return 1 + 7 * this.records.length;
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadFileRecordResponse response = new ReadFileRecordResponse(this.getServerAddress());
        try {
            for (ModbusFileRecord r : this.records) {
                dataHolder.readFileRecord(r);
            }
            response.setFileRecords(this.records);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    protected boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadFileRecordResponse)) {
            return false;
        }
        ModbusFileRecord[] respRecords = ((ReadFileRecordResponse)response).getFileRecords();
        if (this.records.length != respRecords.length) {
            return false;
        }
        for (int i = 0; i < this.records.length; ++i) {
            if (respRecords[i].getRecordLength() == this.records[i].getRecordLength()) continue;
            return false;
        }
        return true;
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_FILE_RECORD.toInt();
    }
}

