/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractDataRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.ReadFifoQueueResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public class ReadFifoQueueRequest
extends AbstractDataRequest {
    public ReadFifoQueueRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadFifoQueueRequest(int serverAddress, int startAddress) throws ModbusNumberException {
        super(serverAddress, startAddress);
    }

    protected void writeData(ModbusOutputStream fifo) throws IOException {
    }

    protected void readData(ModbusInputStream fifo) throws IOException, ModbusNumberException {
    }

    protected int dataSize() {
        return 0;
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadFifoQueueResponse response = new ReadFifoQueueResponse(this.getServerAddress());
        try {
            int[] r = dataHolder.readFifoQueue(this.getStartAddress());
            response.setFifoValueRegister(r);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        return true;
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_FIFO_QUEUE.toInt();
    }
}

