/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.request.ReadCoilsRequest;
import com.invertor.modbus.msg.response.ReadCoilsResponse;
import com.invertor.modbus.msg.response.ReadDiscreteInputsResponse;
import com.invertor.modbus.utils.ModbusFunctionCode;

public final class ReadDiscreteInputsRequest
extends ReadCoilsRequest {
    public ReadDiscreteInputsRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadDiscreteInputsRequest(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        super(serverAddress, startAddress, quantity);
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadDiscreteInputsResponse response = new ReadDiscreteInputsResponse(this.getServerAddress());
        try {
            boolean[] range = dataHolder.readDiscreteInputRange(this.getStartAddress(), this.getQuantity());
            response.setCoils(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_DISCRETE_INPUTS.toInt();
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadDiscreteInputsResponse)) {
            return false;
        }
        ReadDiscreteInputsResponse r = (ReadDiscreteInputsResponse)response;
        return r.getByteCount() == ReadCoilsResponse.calcByteCount(this.getQuantity());
    }
}

