/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractMultipleRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.ReadCoilsResponse;
import com.invertor.modbus.utils.ModbusFunctionCode;

public class ReadCoilsRequest
extends AbstractMultipleRequest {
    public ReadCoilsRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public ReadCoilsRequest(int serverAddress, int startAddress, int quantity) throws ModbusNumberException {
        super(serverAddress, startAddress, quantity);
    }

    public final boolean checkAddressRange(int startAddress, int quantity) {
        return Modbus.checkReadCoilCount(quantity) && Modbus.checkStartAddress(startAddress) && Modbus.checkEndAddress(startAddress + (int)Math.ceil((double)quantity / 16.0));
    }

    public int getFunction() {
        return ModbusFunctionCode.READ_COILS.toInt();
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        ReadCoilsResponse response = new ReadCoilsResponse(this.getServerAddress());
        try {
            boolean[] range = dataHolder.readCoilRange(this.getStartAddress(), this.getQuantity());
            response.setCoils(range);
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof ReadCoilsResponse)) {
            return false;
        }
        ReadCoilsResponse r = (ReadCoilsResponse)response;
        return r.getByteCount() == ReadCoilsResponse.calcByteCount(this.getQuantity());
    }
}

