/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.msg.request;

import com.invertor.modbus.data.DataHolder;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.exception.ModbusProtocolException;
import com.invertor.modbus.msg.base.AbstractDataRequest;
import com.invertor.modbus.msg.base.ModbusResponse;
import com.invertor.modbus.msg.response.MaskWriteRegisterResponse;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class MaskWriteRegisterRequest
extends AbstractDataRequest {
    private int maskAnd;
    private int maskOr;

    public MaskWriteRegisterRequest(int serverAddress) throws ModbusNumberException {
        super(serverAddress);
    }

    public MaskWriteRegisterRequest(int serverAddress, int startAddress, int maskAnd, int maskOr) throws ModbusNumberException {
        super(serverAddress, startAddress);
        this.setMaskAnd(maskAnd);
        this.setMaskOr(maskOr);
    }

    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        MaskWriteRegisterResponse response = new MaskWriteRegisterResponse(this.getServerAddress(), this.getStartAddress(), this.getMaskAnd(), this.getMaskOr());
        try {
            int reg = dataHolder.readHoldingRegister(this.getStartAddress());
            dataHolder.writeHoldingRegister(this.getStartAddress(), reg & this.getMaskAnd() | this.getMaskOr() & ~this.getMaskAnd());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof MaskWriteRegisterResponse)) {
            return false;
        }
        MaskWriteRegisterResponse r = (MaskWriteRegisterResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getMaskAnd() == this.getMaskAnd() && r.getMaskOr() == this.getMaskOr();
    }

    protected void readData(ModbusInputStream fifo) throws IOException {
        this.setMaskAnd(fifo.readShortBE());
        this.setMaskOr(fifo.readShortBE());
    }

    public void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getMaskAnd());
        fifo.writeShortBE(this.getMaskOr());
    }

    public int getFunction() {
        return ModbusFunctionCode.MASK_WRITE_REGISTER.toInt();
    }

    protected int dataSize() {
        return 4;
    }

    public int getMaskAnd() {
        return this.maskAnd;
    }

    public void setMaskAnd(int maskAnd) {
        this.maskAnd = maskAnd;
    }

    public int getMaskOr() {
        return this.maskOr;
    }

    public void setMaskOr(int maskOr) {
        this.maskOr = maskOr;
    }
}

